/*
 * Decompiled with CFR 0.152.
 */
package com.github.bhlangonijr.chesslib.pgn;

import com.github.bhlangonijr.chesslib.game.Event;
import com.github.bhlangonijr.chesslib.game.Game;
import com.github.bhlangonijr.chesslib.game.GameResult;
import com.github.bhlangonijr.chesslib.game.GenericPlayer;
import com.github.bhlangonijr.chesslib.game.Player;
import com.github.bhlangonijr.chesslib.game.PlayerType;
import com.github.bhlangonijr.chesslib.game.Round;
import com.github.bhlangonijr.chesslib.game.Termination;
import com.github.bhlangonijr.chesslib.game.TimeControl;
import com.github.bhlangonijr.chesslib.pgn.PgnException;
import com.github.bhlangonijr.chesslib.pgn.PgnProperty;
import com.github.bhlangonijr.chesslib.util.StringUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;

public class GameLoader {
    public static Game loadNextGame(Iterator<String> iterator) {
        if (!iterator.hasNext()) {
            return null;
        }
        PgnTempContainer container = new PgnTempContainer();
        while (iterator.hasNext()) {
            String line = iterator.next().trim();
            if (line.startsWith("\ufeff")) {
                line = line.substring(1);
            }
            try {
                if (PgnProperty.isProperty(line)) {
                    GameLoader.addProperty(line, container);
                    continue;
                }
                if (!StringUtils.isNotEmpty(line)) continue;
                GameLoader.addMoveText(line, container);
                if (!GameLoader.isEndGame(line)) continue;
                GameLoader.setMoveText(container.game, container.moveText);
                return container.initGame ? container.game : null;
            }
            catch (Exception e) {
                String name = container.event.getName();
                int r = container.round.getNumber();
                throw new PgnException(String.format("Error parsing PGN[%d, %s]: ", r, name), e);
            }
        }
        return container.initGame ? container.game : null;
    }

    private static void addProperty(String line, PgnTempContainer container) throws Exception {
        String tag;
        PgnProperty property = PgnProperty.parsePgnProperty(line);
        if (property == null) {
            return;
        }
        container.initGame = true;
        switch (tag = property.name.toLowerCase().trim()) {
            case "event": {
                if (container.moveTextParsing && container.game.getHalfMoves().size() == 0) {
                    GameLoader.setMoveText(container.game, container.moveText);
                }
                container.event.setName(property.value);
                container.event.setId(property.value);
                break;
            }
            case "site": {
                container.event.setSite(property.value);
                break;
            }
            case "date": {
                container.event.setStartDate(property.value);
                break;
            }
            case "round": {
                int r = 1;
                try {
                    r = Integer.parseInt(property.value);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                r = Math.max(0, r);
                container.round.setNumber(r);
                if (container.event.getRound().containsKey(r)) break;
                container.event.getRound().put(r, container.round);
                break;
            }
            case "white": {
                if (container.round.getNumber() < 1) {
                    container.round.setNumber(1);
                }
                container.game.setDate(container.event.getStartDate());
                container.whitePlayer.setId(property.value);
                container.whitePlayer.setName(property.value);
                container.whitePlayer.setDescription(property.value);
                break;
            }
            case "black": {
                if (container.round.getNumber() < 1) {
                    container.round.setNumber(1);
                }
                container.game.setDate(container.event.getStartDate());
                container.blackPlayer.setId(property.value);
                container.blackPlayer.setName(property.value);
                container.blackPlayer.setDescription(property.value);
                break;
            }
            case "result": {
                container.game.setResult(GameResult.fromNotation(property.value));
                break;
            }
            case "plycount": {
                container.game.setPlyCount(property.value);
                break;
            }
            case "termination": {
                try {
                    container.game.setTermination(Termination.fromValue(property.value.toUpperCase()));
                }
                catch (Exception e1) {
                    container.game.setTermination(Termination.UNTERMINATED);
                }
                break;
            }
            case "timecontrol": {
                if (container.event.getTimeControl() != null) break;
                try {
                    container.event.setTimeControl(TimeControl.parseFromString(property.value.toUpperCase()));
                }
                catch (Exception exception) {}
                break;
            }
            case "annotator": {
                container.game.setAnnotator(property.value);
                break;
            }
            case "fen": {
                container.game.setFen(property.value);
                break;
            }
            case "eco": {
                container.game.setEco(property.value);
                break;
            }
            case "opening": {
                container.game.setOpening(property.value);
                break;
            }
            case "variation": {
                container.game.setVariation(property.value);
                break;
            }
            case "whiteelo": {
                try {
                    container.whitePlayer.setElo(Integer.parseInt(property.value));
                }
                catch (NumberFormatException numberFormatException) {}
                break;
            }
            case "blackelo": {
                try {
                    container.blackPlayer.setElo(Integer.parseInt(property.value));
                }
                catch (NumberFormatException numberFormatException) {}
                break;
            }
            default: {
                if (container.game.getProperty() == null) {
                    container.game.setProperty(new HashMap<String, String>());
                }
                container.game.getProperty().put(property.name, property.value);
            }
        }
    }

    private static void addMoveText(String line, PgnTempContainer container) {
        container.initGame = true;
        container.moveText.append(line);
        container.moveText.append('\n');
        container.moveTextParsing = true;
    }

    private static boolean isEndGame(String line) {
        return line.endsWith("1-0") || line.endsWith("0-1") || line.endsWith("1/2-1/2") || line.endsWith("*");
    }

    private static void setMoveText(Game game, StringBuilder moveText) throws Exception {
        StringUtil.replaceAll(moveText, "1-0", "");
        StringUtil.replaceAll(moveText, "0-1", "");
        StringUtil.replaceAll(moveText, "1/2-1/2", "");
        StringUtil.replaceAll(moveText, "*", "");
        game.setMoveText(moveText);
        game.loadMoveText(moveText);
        game.setPlyCount(String.valueOf(game.getHalfMoves().size()));
    }

    private static class PgnTempContainer {
        final Event event = new Event();
        final Round round = new Round(this.event);
        final Game game = new Game(UUID.randomUUID().toString(), this.round);
        Player whitePlayer;
        Player blackPlayer;
        final StringBuilder moveText;
        boolean moveTextParsing;
        boolean initGame;

        PgnTempContainer() {
            this.round.getGame().add(this.game);
            this.whitePlayer = new GenericPlayer();
            this.whitePlayer.setType(PlayerType.HUMAN);
            this.game.setWhitePlayer(this.whitePlayer);
            this.blackPlayer = new GenericPlayer();
            this.blackPlayer.setType(PlayerType.HUMAN);
            this.game.setBlackPlayer(this.blackPlayer);
            this.moveText = new StringBuilder();
        }
    }
}

