/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.jchess.uci.parameters;

import com.fathzer.jchess.uci.parameters.ParameterDefinition;
import com.fathzer.jchess.uci.parameters.Parser;
import java.util.Collections;
import java.util.Deque;
import java.util.List;

public class PerfTParameters {
    public static final Parser<PerfTParameters> PARSER = new PerfTLikeParser<PerfTParameters>();
    private int depth = -1;
    private int parallelism = 1;
    private boolean legal = false;
    private boolean playLeaves = false;

    public int getDepth() {
        return this.depth;
    }

    void setDepth(int depth) {
        if (depth < 1) {
            throw new IllegalArgumentException();
        }
        this.depth = depth;
    }

    public int getParallelism() {
        return this.parallelism;
    }

    void setParallelism(int parallelism) {
        if (parallelism < 1) {
            throw new IllegalArgumentException();
        }
        this.parallelism = parallelism;
    }

    public boolean isLegal() {
        return this.legal;
    }

    void setLegal(boolean legal) {
        this.legal = legal;
    }

    public boolean isPlayLeaves() {
        return this.playLeaves;
    }

    void setPlayLeaves(boolean playLeaves) {
        this.playLeaves = playLeaves;
    }

    public static class PerfTLikeParser<T extends PerfTParameters>
    extends Parser<T> {
        protected PerfTLikeParser() {
            super(Collections.emptyList());
            this.add(new ParameterDefinition<PerfTParameters>((p, tok) -> p.setParallelism(Parser.positiveInt(tok)), "threads", "t"));
            this.add(new ParameterDefinition<PerfTParameters>((p, tok) -> p.setLegal(true), "legal", "l"));
            this.add(new ParameterDefinition<PerfTParameters>((p, tok) -> p.setPlayLeaves(true), "playleaves", "pl"));
        }

        @Override
        public List<String> parse(T target, Deque<String> tokens) {
            ((PerfTParameters)target).setDepth(PerfTLikeParser.positiveInt(tokens));
            return super.parse(target, tokens);
        }
    }
}

