/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.jchess.uci.parameters;

import com.fathzer.jchess.uci.parameters.ParameterDefinition;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;

public class Parser<T> {
    private final Map<String, BiConsumer<T, Deque<String>>> parserMap = new HashMap<String, BiConsumer<T, Deque<String>>>();

    public Parser(Collection<ParameterDefinition<T>> paramDefinitions) {
        for (ParameterDefinition<T> param : paramDefinitions) {
            this.add(param);
        }
    }

    public void add(ParameterDefinition<T> property) {
        for (String name : property.getNames()) {
            if (this.parserMap.putIfAbsent(name, property.getParser()) == null) continue;
            throw new IllegalArgumentException(name + " is already registered");
        }
    }

    public List<String> parse(T target, Deque<String> tokens) {
        LinkedList<String> ignoredOptions = new LinkedList<String>();
        while (!tokens.isEmpty()) {
            String arg;
            String token = tokens.pop();
            BiConsumer<T, Deque<String>> parser = this.parserMap.get(token);
            if (parser == null) {
                ignoredOptions.add(token);
                continue;
            }
            LinkedList<String> arguments = new LinkedList<String>();
            while (!tokens.isEmpty() && !this.parserMap.containsKey(arg = tokens.peek())) {
                tokens.pop();
                arguments.add(arg);
            }
            parser.accept(target, arguments);
            if (arguments.isEmpty()) continue;
            ignoredOptions.addAll(arguments);
        }
        return ignoredOptions;
    }

    public static int positiveInt(Deque<String> arguments) {
        if (arguments.isEmpty()) {
            throw new IllegalArgumentException("Expected a value, but none is provided");
        }
        String value = arguments.pop();
        int result = Integer.parseInt(value);
        if (result < 0) {
            throw new IllegalArgumentException("Unexpected negative number " + value);
        }
        return result;
    }
}

