/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.jchess.uci.parameters;

import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.function.BiConsumer;

public class ParameterDefinition<T> {
    private final List<String> names;
    private final BiConsumer<T, Deque<String>> parser;

    public ParameterDefinition(BiConsumer<T, Deque<String>> parser, String name, String ... aliases) {
        if (parser == null) {
            throw new IllegalArgumentException();
        }
        this.names = new LinkedList<String>();
        this.names.add(name);
        this.names.addAll(Arrays.asList(aliases));
        if (this.names.stream().anyMatch(n -> n == null || n.isBlank())) {
            throw new IllegalArgumentException();
        }
        this.parser = parser;
    }

    public List<String> getNames() {
        return Collections.unmodifiableList(this.names);
    }

    public BiConsumer<T, Deque<String>> getParser() {
        return this.parser;
    }
}

