/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.jchess.uci.parameters;

import com.fathzer.jchess.uci.UCIMove;
import com.fathzer.jchess.uci.parameters.ParameterDefinition;
import com.fathzer.jchess.uci.parameters.Parser;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class GoParameters {
    private static final ParameterDefinition<GoParameters> WTIME_PARAM = new ParameterDefinition<GoParameters>((p, tok) -> {
        p.time.whiteClock.remainingMs = Parser.positiveInt(tok);
    }, "wtime", new String[0]);
    private static final ParameterDefinition<GoParameters> WHITE_TIME_INC_PARAM = new ParameterDefinition<GoParameters>((p, tok) -> {
        p.time.whiteClock.incrementMs = Parser.positiveInt(tok);
    }, "winc", new String[0]);
    private static final ParameterDefinition<GoParameters> BTIME_PARAM = new ParameterDefinition<GoParameters>((p, tok) -> {
        p.time.blackClock.remainingMs = Parser.positiveInt(tok);
    }, "btime", new String[0]);
    private static final ParameterDefinition<GoParameters> BLACK_TIME_INC_PARAM = new ParameterDefinition<GoParameters>((p, tok) -> {
        p.time.blackClock.incrementMs = Parser.positiveInt(tok);
    }, "binc", new String[0]);
    private static final ParameterDefinition<GoParameters> MOVES_TO_GO_PARAM = new ParameterDefinition<GoParameters>((p, tok) -> {
        p.time.movesToGo = Parser.positiveInt(tok);
    }, "movestogo", new String[0]);
    private static final ParameterDefinition<GoParameters> MOVE_TIME_PARAM = new ParameterDefinition<GoParameters>((p, tok) -> {
        p.time.moveTimeMs = Parser.positiveInt(tok);
    }, "movetime", new String[0]);
    private static final ParameterDefinition<GoParameters> INFINITE_PARAM = new ParameterDefinition<GoParameters>((p, tok) -> {
        p.time.infinite = true;
    }, "infinite", new String[0]);
    private static final ParameterDefinition<GoParameters> DEPTH_PARAM = new ParameterDefinition<GoParameters>((p, tok) -> {
        p.depth = Parser.positiveInt(tok);
    }, "depth", new String[0]);
    private static final ParameterDefinition<GoParameters> NODES_PARAM = new ParameterDefinition<GoParameters>((p, tok) -> {
        p.nodes = Parser.positiveInt(tok);
    }, "nodes", new String[0]);
    private static final ParameterDefinition<GoParameters> MATE_PARAM = new ParameterDefinition<GoParameters>((p, tok) -> {
        p.mate = Parser.positiveInt(tok);
    }, "mate", new String[0]);
    private static final ParameterDefinition<GoParameters> PONDER_PARAM = new ParameterDefinition<GoParameters>((p, tok) -> {
        p.ponder = true;
    }, "ponder", new String[0]);
    private static final ParameterDefinition<GoParameters> SEARCH_MOVES_PARAM = new ParameterDefinition<GoParameters>((p, tok) -> {
        while (!tok.isEmpty()) {
            p.moveToSearch.add(UCIMove.from((String)tok.pop()));
        }
    }, "searchmoves", new String[0]);
    public static final Parser<GoParameters> PARSER = new Parser(Arrays.asList(WTIME_PARAM, WHITE_TIME_INC_PARAM, BTIME_PARAM, BLACK_TIME_INC_PARAM, MOVES_TO_GO_PARAM, MOVE_TIME_PARAM, INFINITE_PARAM, DEPTH_PARAM, NODES_PARAM, MATE_PARAM, PONDER_PARAM, SEARCH_MOVES_PARAM));
    private TimeOptions time = new TimeOptions();
    private boolean ponder;
    private int depth = 0;
    private int nodes = 0;
    private int mate = 0;
    private List<UCIMove> moveToSearch = new LinkedList<UCIMove>();

    public TimeOptions getTimeOptions() {
        return this.time;
    }

    public int getDepth() {
        return this.depth;
    }

    public int getNodes() {
        return this.nodes;
    }

    public int getMate() {
        return this.mate;
    }

    public boolean isPonder() {
        return this.ponder;
    }

    public List<UCIMove> getMoveToSearch() {
        return this.moveToSearch;
    }

    public static class TimeOptions {
        private int movesToGo;
        private int moveTimeMs;
        private PlayerClockData whiteClock = new PlayerClockData();
        private PlayerClockData blackClock = new PlayerClockData();
        private boolean infinite;

        public int getMovesToGo() {
            return this.movesToGo;
        }

        public int getMoveTimeMs() {
            return this.moveTimeMs;
        }

        public PlayerClockData getWhiteClock() {
            return this.whiteClock;
        }

        public PlayerClockData getBlackClock() {
            return this.blackClock;
        }

        public boolean isInfinite() {
            return this.infinite;
        }
    }

    public static class PlayerClockData {
        private int remainingMs;
        private int incrementMs;

        public int getRemainingMs() {
            return this.remainingMs;
        }

        public int getIncrementMs() {
            return this.incrementMs;
        }
    }
}

