/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.jchess.uci.option;

import com.fathzer.jchess.uci.option.Option;
import java.util.function.Consumer;

public abstract class SpinOption<N extends Number>
extends Option<N> {
    private final N defaultValue;
    private final N min;
    private final N max;

    protected SpinOption(String name, Consumer<N> trigger, N defaultValue, N min, N max) {
        super(name, trigger);
        if (((Comparable)defaultValue).compareTo(min) < 0 || ((Comparable)defaultValue).compareTo(max) > 0) {
            throw new IllegalArgumentException("default (" + defaultValue + ") is not between min (" + min + ") and max(" + max + ")");
        }
        this.defaultValue = defaultValue;
        this.setCastedValue(defaultValue);
        this.min = min;
        this.max = max;
    }

    protected abstract N parse(String var1);

    @Override
    Option.Type getType() {
        return Option.Type.SPIN;
    }

    @Override
    public void setValue(String value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        N val = this.parse(value);
        if (((Comparable)val).compareTo(this.max) > 0 || ((Comparable)val).compareTo(this.min) < 0) {
            throw new IllegalArgumentException();
        }
        this.setCastedValue(val);
    }

    @Override
    public String toUCI() {
        return super.toUCI() + " default " + this.defaultValue + " min " + this.min + " max " + this.max;
    }
}

