/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.jchess.uci.option;

import java.util.Objects;
import java.util.function.Consumer;

public abstract class Option<T> {
    static final String DEFAULT = " default ";
    private final String name;
    private T value;
    private final Consumer<T> trigger;

    Option(String name, Consumer<T> trigger) {
        if (name == null || trigger == null) {
            throw new IllegalArgumentException();
        }
        this.name = name;
        this.value = null;
        this.trigger = trigger;
    }

    public String getName() {
        return this.name;
    }

    abstract Type getType();

    public T getValue() {
        return this.value;
    }

    public abstract void setValue(String var1);

    void setCastedValue(T value) {
        boolean equals = Objects.equals(this.value, value);
        this.value = value;
        if (!equals || Type.BUTTON.equals((Object)this.getType())) {
            this.trigger.accept(value);
        }
    }

    public String toUCI() {
        return "option name " + this.getName() + " type " + this.getType().toString().toLowerCase();
    }

    static enum Type {
        CHECK,
        SPIN,
        COMBO,
        BUTTON,
        STRING;

    }
}

