/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.jchess.uci.option;

import com.fathzer.jchess.uci.option.Option;
import java.util.function.Consumer;

public class CheckOption
extends Option<Boolean> {
    private final boolean defaultValue;

    public CheckOption(String name, Consumer<Boolean> trigger, boolean defaultValue) {
        super(name, trigger);
        this.defaultValue = defaultValue;
        this.setCastedValue(defaultValue);
    }

    @Override
    Option.Type getType() {
        return Option.Type.CHECK;
    }

    @Override
    public void setValue(String value) {
        if ("true".equals(value)) {
            this.setCastedValue(true);
        } else if ("false".equals(value)) {
            this.setCastedValue(false);
        } else {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public String toUCI() {
        return super.toUCI() + " default " + this.defaultValue;
    }
}

