/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.jchess.uci.helper;

import com.fathzer.games.MoveGenerator;
import com.fathzer.games.ai.iterativedeepening.IterativeDeepeningEngine;
import com.fathzer.games.ai.time.TimeManager;
import com.fathzer.games.clock.CountDownState;
import com.fathzer.jchess.uci.parameters.GoParameters;

class UCIEngineSearchConfiguration<M, B extends MoveGenerator<M>> {
    private TimeManager<B> timeManager;

    public UCIEngineSearchConfiguration(TimeManager<B> timeManager) {
        this.timeManager = timeManager;
    }

    EngineConfiguration configure(IterativeDeepeningEngine<M, B> engine, GoParameters options, B board) {
        EngineConfiguration result = new EngineConfiguration(engine);
        GoParameters.TimeOptions timeOptions = options.getTimeOptions();
        if (options.isPonder() || !options.getMoveToSearch().isEmpty() || options.getMate() > 0 || options.getNodes() > 0 || timeOptions.isInfinite()) {
            // empty if block
        }
        if (options.getDepth() > 0) {
            engine.getDeepeningPolicy().setDepth(options.getDepth());
            engine.getDeepeningPolicy().setDeepenOnForced(true);
        }
        if (timeOptions.getMoveTimeMs() > 0) {
            engine.getDeepeningPolicy().setMaxTime(timeOptions.getMoveTimeMs());
        } else {
            GoParameters.PlayerClockData engineClock;
            GoParameters.PlayerClockData playerClockData = engineClock = board.isWhiteToMove() ? timeOptions.getWhiteClock() : timeOptions.getBlackClock();
            if (engineClock.getRemainingMs() > 0) {
                engine.getDeepeningPolicy().setMaxTime(this.getMaxTime(board, engineClock.getRemainingMs(), engineClock.getIncrementMs(), timeOptions.getMovesToGo()));
            }
        }
        return result;
    }

    void set(IterativeDeepeningEngine<M, B> engine, EngineConfiguration c) {
        engine.getDeepeningPolicy().setMaxTime(c.maxTime);
        engine.getDeepeningPolicy().setDepth(c.depth);
        engine.getDeepeningPolicy().setDeepenOnForced(c.deepenOnForced);
    }

    long getMaxTime(B board, long remainingMs, long incrementMs, int movesToGo) {
        return this.timeManager.getMaxTime(board, new CountDownState(remainingMs, incrementMs, movesToGo));
    }

    static class EngineConfiguration {
        private long maxTime;
        private int depth;
        private boolean deepenOnForced;

        private EngineConfiguration(IterativeDeepeningEngine<?, ?> engine) {
            this.maxTime = engine.getDeepeningPolicy().getMaxTime();
            this.depth = engine.getDeepeningPolicy().getDepth();
            this.deepenOnForced = engine.getDeepeningPolicy().isDeepenOnForced();
        }
    }
}

