/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.jchess.uci.helper;

import com.fathzer.games.MoveGenerator;
import com.fathzer.games.ai.evaluation.EvaluatedMove;
import com.fathzer.games.movelibrary.MoveLibrary;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class DeferredReadMoveLibrary<M, B extends MoveGenerator<M>>
implements MoveLibrary<M, B> {
    private final String url;
    private final IOReader<MoveLibrary<M, B>> reader;
    private MoveLibrary<M, B> internal;

    public DeferredReadMoveLibrary(String url, IOReader<MoveLibrary<M, B>> reader) {
        if (url == null || reader == null) {
            throw new IllegalArgumentException();
        }
        this.url = url;
        this.reader = reader;
    }

    @Override
    public List<EvaluatedMove<M>> getMoves(B board) {
        if (this.internal == null) {
            return Collections.emptyList();
        }
        return this.internal.getMoves(board);
    }

    @Override
    public Optional<EvaluatedMove<M>> apply(B board) {
        if (this.internal == null) {
            return Optional.empty();
        }
        return this.internal.apply((Object)board);
    }

    public boolean isInitRequired() {
        return this.internal == null;
    }

    public void init() throws IOException {
        if (this.isInitRequired()) {
            this.internal = this.reader.read(DeferredReadMoveLibrary.toURL(this.url));
        }
    }

    static URL toURL(String path) throws IOException {
        URL url;
        try {
            url = new URL(path);
        }
        catch (MalformedURLException e) {
            File file = new File(path);
            if (!file.exists()) {
                throw new FileNotFoundException();
            }
            url = file.toURI().toURL();
        }
        return url;
    }

    public String getUrl() {
        return this.url;
    }

    @FunctionalInterface
    public static interface IOReader<T> {
        public T read(URL var1) throws IOException;
    }
}

