/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.jchess.uci.helper;

import com.fathzer.games.HashProvider;
import com.fathzer.games.MoveGenerator;
import com.fathzer.games.ai.evaluation.EvaluatedMove;
import com.fathzer.games.ai.evaluation.Evaluation;
import com.fathzer.games.ai.evaluation.Evaluator;
import com.fathzer.games.ai.iterativedeepening.IterativeDeepeningEngine;
import com.fathzer.games.ai.iterativedeepening.SearchHistory;
import com.fathzer.games.ai.time.TimeManager;
import com.fathzer.games.ai.transposition.TranspositionTable;
import com.fathzer.jchess.uci.Engine;
import com.fathzer.jchess.uci.GoReply;
import com.fathzer.jchess.uci.StoppableTask;
import com.fathzer.jchess.uci.UCIMove;
import com.fathzer.jchess.uci.UsualOptions;
import com.fathzer.jchess.uci.extended.MoveGeneratorSupplier;
import com.fathzer.jchess.uci.extended.MoveToUCIConverter;
import com.fathzer.jchess.uci.helper.EvaluatorConfiguration;
import com.fathzer.jchess.uci.helper.UCIEngineSearchConfiguration;
import com.fathzer.jchess.uci.option.ComboOption;
import com.fathzer.jchess.uci.option.IntegerSpinOption;
import com.fathzer.jchess.uci.option.LongSpinOption;
import com.fathzer.jchess.uci.option.Option;
import com.fathzer.jchess.uci.parameters.GoParameters;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public abstract class AbstractEngine<M, B extends MoveGenerator<M>>
implements Engine,
MoveGeneratorSupplier<M>,
MoveToUCIConverter<M> {
    protected B board;
    protected TimeManager<B> timeManager;
    protected IterativeDeepeningEngine<M, B> engine;
    private Map<String, Supplier<Evaluator<M, B>>> evaluatorBuilders;
    private String defaultEvaluator;
    private int defaultThreads;
    private int defaultDepth;
    private long defaultMaxTime;
    private int ttSizeInMB;

    protected AbstractEngine(IterativeDeepeningEngine<M, B> engine, TimeManager<B> timeManager) {
        this.engine = engine;
        TranspositionTable<M, B> transpositionTable = engine.getTranspositionTable();
        this.ttSizeInMB = transpositionTable == null ? -1 : transpositionTable.getMemorySizeMB();
        this.defaultThreads = engine.getParallelism();
        this.defaultDepth = engine.getDeepeningPolicy().getDepth();
        this.defaultMaxTime = engine.getDeepeningPolicy().getMaxTime();
        this.timeManager = timeManager;
        this.evaluatorBuilders = new HashMap<String, Supplier<Evaluator<M, B>>>();
    }

    protected void setEvaluators(List<EvaluatorConfiguration<M, B>> evaluators) {
        this.evaluatorBuilders.clear();
        this.defaultEvaluator = evaluators.isEmpty() ? null : evaluators.get(0).name();
        evaluators.forEach(e -> this.evaluatorBuilders.put(e.name(), e.evaluatorBuilder()));
    }

    @Override
    public int getDefaultHashTableSize() {
        return this.ttSizeInMB;
    }

    @Override
    public void setHashTableSize(int sizeInMB) {
        int currentSize;
        TranspositionTable<M, B> transpositionTable = this.engine.getTranspositionTable();
        int n = currentSize = transpositionTable == null ? 0 : transpositionTable.getMemorySizeMB();
        if (currentSize != sizeInMB) {
            this.engine.setTranspositionTable(sizeInMB <= 0 ? null : this.buildTranspositionTable(sizeInMB));
        }
    }

    @Override
    public void clearHashTable() {
        TranspositionTable<M, B> transpositionTable = this.engine.getTranspositionTable();
        if (transpositionTable != null) {
            transpositionTable.newGame();
        }
    }

    protected abstract TranspositionTable<M, B> buildTranspositionTable(int var1);

    @Override
    public void newGame() {
        this.engine.newGame();
    }

    @Override
    public Map<String, Option<?>> getOptions() {
        Map<String, Option<?>> options = Engine.super.getOptions();
        if (!this.evaluatorBuilders.isEmpty()) {
            this.add(options, new ComboOption("evaluation", n -> this.engine.setEvaluatorSupplier(this.evaluatorBuilders.get(n)), this.defaultEvaluator, this.evaluatorBuilders.keySet()));
        }
        this.add(options, UsualOptions.threads(this.engine::setParallelism, this.defaultThreads));
        this.add(options, UsualOptions.multiPV(this.engine.getDeepeningPolicy()::setSize));
        this.add(options, new IntegerSpinOption("depth", this.engine.getDeepeningPolicy()::setDepth, this.defaultDepth, 1, 128));
        this.add(options, new LongSpinOption("maxtime", this.engine.getDeepeningPolicy()::setMaxTime, this.defaultMaxTime, 1L, Long.MAX_VALUE));
        return options;
    }

    private void add(Map<String, Option<?>> map, Option<?> option) {
        map.put(option.getName(), option);
    }

    protected abstract M toMove(UCIMove var1);

    @Override
    public void move(UCIMove move) {
        this.board.makeMove(this.toMove(move), MoveGenerator.MoveConfidence.LEGAL);
    }

    @Override
    public StoppableTask<GoReply> go(final GoParameters options) {
        return new StoppableTask<GoReply>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public GoReply call() {
                UCIEngineSearchConfiguration c = new UCIEngineSearchConfiguration(AbstractEngine.this.timeManager);
                UCIEngineSearchConfiguration.EngineConfiguration previous = c.configure(AbstractEngine.this.engine, options, AbstractEngine.this.board);
                try {
                    List<Object> candidates = options.getMoveToSearch().stream().map(AbstractEngine.this::toMove).toList();
                    SearchHistory<Object> search = AbstractEngine.this.engine.getBestMoves(AbstractEngine.this.board, candidates.isEmpty() ? null : candidates);
                    if (search.isEmpty()) {
                        GoReply goReply = new GoReply(null);
                        return goReply;
                    }
                    EvaluatedMove<Object> move = AbstractEngine.this.getSelected(AbstractEngine.this.board, search);
                    GoReply goReply = new GoReply(AbstractEngine.this.toUCI(move.getMove()));
                    GoReply.Info info = new GoReply.Info(search.getLastDepth());
                    TranspositionTable tt = AbstractEngine.this.engine.getTranspositionTable();
                    int entryCount = tt.getEntryCount();
                    if (entryCount > 0) {
                        info.setHashFull((int)(1000L * (long)entryCount / (long)tt.getSize()));
                    }
                    List<EvaluatedMove<Object>> bestMoves = search.getAccurateMoves();
                    Map<String, Optional> scores = bestMoves.stream().collect(Collectors.toMap(em -> AbstractEngine.this.toUCI(em.getMove()).toString(), em -> AbstractEngine.this.toScore(em.getEvaluation())));
                    info.setScoreBuilder(m -> (Optional)scores.get(m.toString()));
                    Map<UCIMove, List> pvs = bestMoves.stream().map(EvaluatedMove::getMove).collect(Collectors.toMap(m -> AbstractEngine.this.toUCI(m), em -> this.getPV(tt, AbstractEngine.this.board, em, info.getDepth())));
                    info.setPvBuilder(pvs::get);
                    info.setExtraMoves(bestMoves.stream().filter(em -> !move.getMove().equals(em.getMove())).limit((long)AbstractEngine.this.engine.getDeepeningPolicy().getSize() - 1L).map(em -> AbstractEngine.this.toUCI(em.getMove())).toList());
                    goReply.setInfo(info);
                    GoReply goReply2 = goReply;
                    return goReply2;
                }
                finally {
                    c.set(AbstractEngine.this.engine, previous);
                }
            }

            private <V extends MoveGenerator<M> & HashProvider> List<UCIMove> getPV(TranspositionTable<M, B> tt, B board, M move, int depth) {
                return tt.collectPV(board, move, depth).stream().map(m -> AbstractEngine.this.toUCI(m)).toList();
            }

            @Override
            public void stop() {
                AbstractEngine.this.engine.interrupt();
            }
        };
    }

    protected EvaluatedMove<M> getSelected(B board, SearchHistory<M> history) {
        return history.getAccurateMoves().get(0);
    }

    private Optional<GoReply.Score> toScore(Evaluation evaluation) {
        Record score;
        Evaluation.Type type = evaluation.getType();
        if (type == Evaluation.Type.UNKNOWN) {
            score = null;
        } else if (type == Evaluation.Type.EVAL) {
            score = new GoReply.CpScore(evaluation.getScore());
        } else if (type == Evaluation.Type.WIN) {
            score = new GoReply.MateScore(evaluation.getCountToEnd());
        } else if (type == Evaluation.Type.LOOSE) {
            score = new GoReply.MateScore(-evaluation.getCountToEnd());
        } else {
            throw new IllegalArgumentException("Type " + type + " is not supported");
        }
        return Optional.ofNullable(score);
    }

    public B getMoveGenerator() {
        return this.board;
    }

    public IterativeDeepeningEngine<M, B> getEngine() {
        return this.engine;
    }
}

