/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.jchess.uci.extended;

import com.fathzer.games.MoveGenerator;
import com.fathzer.games.ai.evaluation.EvaluatedMove;
import com.fathzer.games.ai.evaluation.Evaluation;
import com.fathzer.games.ai.iterativedeepening.DeepeningPolicy;
import com.fathzer.jchess.uci.UCIMove;
import com.fathzer.jchess.uci.extended.Displayable;
import com.fathzer.jchess.uci.helper.AbstractEngine;
import java.util.List;
import java.util.function.Consumer;

public class SpeedTest<M, B extends MoveGenerator<M>> {
    private final AbstractEngine<M, B> uciEngine;
    private final Consumer<CharSequence> out;

    public SpeedTest(AbstractEngine<M, B> engine, Consumer<CharSequence> out) {
        this.uciEngine = engine;
        this.out = out;
    }

    protected boolean hasRegularThreeFoldRepetitionDetection() {
        return true;
    }

    private Result<M> fill(String fen) {
        this.uciEngine.newGame();
        this.uciEngine.setStartPosition(fen);
        return new Result<M>(fen, this.uciEngine.getEngine().getBestMoves(this.uciEngine.getMoveGenerator()).getAccurateMoves(), this.out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long run() {
        String string;
        DeepeningPolicy policy = this.uciEngine.getEngine().getDeepeningPolicy();
        int size = policy.getSize();
        int accuracy = policy.getAccuracy();
        int depth = policy.getDepth();
        AbstractEngine<M, B> abstractEngine = this.uciEngine;
        if (abstractEngine instanceof Displayable) {
            Displayable displayable = (Displayable)((Object)abstractEngine);
            string = displayable.getFEN();
        } else {
            string = null;
        }
        String fen = string;
        try {
            long start = System.currentTimeMillis();
            this.doSpeedTest();
            long l = System.currentTimeMillis() - start;
            return l;
        }
        finally {
            policy.setDepth(depth);
            policy.setSize(size);
            policy.setAccuracy(accuracy);
            if (fen != null) {
                this.uciEngine.newGame();
                this.uciEngine.setStartPosition(fen);
            }
        }
    }

    private void doSpeedTest() {
        DeepeningPolicy policy = this.uciEngine.getEngine().getDeepeningPolicy();
        policy.setSize(Integer.MAX_VALUE);
        policy.setDepth(8);
        Result<M> mv = this.fill("7k/5p2/5PQN/5PPK/6PP/8/8/8 w - - 6 5");
        mv.assertEquals(6, mv.moves.size());
        Evaluation max = mv.moves.get(0).getEvaluation();
        mv.assertEquals((Object)Evaluation.Type.WIN, (Object)max.getType());
        mv.assertEquals(1, max.getCountToEnd());
        mv.assertTrue(mv.moves.get(3).getEvaluation().compareTo(max) < 0);
        for (int i = 1; i < 3; ++i) {
            mv.assertEquals(max, mv.moves.get(i).getEvaluation());
        }
        mv = this.fill("1R6/8/8/7R/k7/ppp1p3/r2bP3/1K6 b - - 6 5");
        mv.assertEquals(7, mv.moves.size());
        max = mv.moves.get(0).getEvaluation();
        mv.assertEquals((Object)Evaluation.Type.WIN, (Object)max.getType());
        mv.assertEquals(1, max.getCountToEnd());
        mv.assertEquals(UCIMove.from("c3c2"), this.uciEngine.toUCI(mv.moves.get(0).getMove()));
        if (this.hasRegularThreeFoldRepetitionDetection()) {
            max = mv.moves.get(1).getEvaluation();
            mv.assertEquals((Object)Evaluation.Type.WIN, (Object)max.getType());
            mv.assertEquals(3, max.getCountToEnd());
            Evaluation evaluation = mv.moves.get(2).getEvaluation();
            mv.assertTrue(Evaluation.Type.EVAL == evaluation.getType() || evaluation.getType() == Evaluation.Type.WIN && evaluation.getCountToEnd() > 8);
        }
        mv = this.fill("8/8/8/8/1B6/NN6/pk1K4/8 w - - 0 1");
        max = mv.moves.get(0).getEvaluation();
        mv.assertEquals((Object)Evaluation.Type.WIN, (Object)max.getType());
        mv.assertEquals(2, max.getCountToEnd());
        mv.assertTrue(mv.moves.get(1).getScore() < max.getScore());
        mv.assertEquals(UCIMove.from("b3a1"), this.uciEngine.toUCI(mv.moves.get(0).getMove()));
        mv = this.fill("8/4k1KP/6nn/6b1/8/8/8/8 b - - 0 1");
        max = mv.moves.get(0).getEvaluation();
        mv.assertEquals((Object)Evaluation.Type.WIN, (Object)max.getType());
        mv.assertEquals(2, max.getCountToEnd());
        mv.assertTrue(mv.moves.get(1).getScore() < max.getScore());
        mv.assertEquals(UCIMove.from("g6h8"), this.uciEngine.toUCI(mv.moves.get(0).getMove()));
        policy.setSize(3);
        policy.setAccuracy(100);
        mv = this.fill("r2k1r2/pp1b2pp/1b2Pn2/2p5/Q1B2Bq1/2P5/P5PP/3R1RK1 w - - 0 1");
        mv.assertEquals(UCIMove.from("d1d7"), this.uciEngine.toUCI(mv.moves.get(0).getMove()));
        policy.setSize(1);
        policy.setAccuracy(0);
        mv = this.fill("8/4k3/8/R7/8/8/8/4K2R w K - 0 1");
        mv.assertEquals(2, mv.moves.size());
        mv.assertEquals((Object)Evaluation.Type.WIN, (Object)mv.moves.get(0).getEvaluation().getType());
        mv.assertEquals(4, mv.moves.get(0).getEvaluation().getCountToEnd());
        mv.assertEquals((Object)Evaluation.Type.WIN, (Object)mv.moves.get(1).getEvaluation().getType());
        mv.assertEquals(4, mv.moves.get(1).getEvaluation().getCountToEnd());
    }

    private record Result<M>(String fen, List<EvaluatedMove<M>> moves, Consumer<CharSequence> out) {
        private void assertEquals(Object expected, Object actual) {
            if (!expected.equals(actual)) {
                this.show();
                throw new IllegalArgumentException("Expecting " + expected + " but is " + actual);
            }
        }

        private void assertTrue(boolean value) {
            if (!value) {
                this.show();
                throw new IllegalArgumentException("Expecting true here");
            }
        }

        private void show() {
            this.out.accept(this.fen);
            this.out.accept(this.moves.toString());
        }
    }
}

