/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.jchess.uci.extended;

import com.fathzer.games.MoveGenerator;
import com.fathzer.games.perft.PerfT;
import com.fathzer.games.perft.PerfTBuilder;
import com.fathzer.games.perft.PerfTResult;
import com.fathzer.jchess.uci.StoppableTask;
import com.fathzer.jchess.uci.parameters.PerfTParameters;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Supplier;

class PerftTask<M>
implements StoppableTask<PerfTResult<M>> {
    private PerfT<M> perft;
    private final Supplier<MoveGenerator<M>> engine;
    private final PerfTParameters params;

    public PerftTask(Supplier<MoveGenerator<M>> engine, PerfTParameters params) {
        this.engine = engine;
        this.params = params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PerfTResult<M> call() {
        PerfTBuilder<M> builder = this.createBuilder();
        if (this.params.isLegal()) {
            builder.setLegalMoves(true);
            if (!this.params.isPlayLeaves()) {
                builder.setPlayLeaves(false);
            }
        }
        ForkJoinPool exec = new ForkJoinPool(this.params.getParallelism());
        try {
            builder.setExecutor(exec);
            this.perft = builder.build((MoveGenerator)this.engine.get().fork(), this.params.getDepth());
            PerfTResult<M> perfTResult = this.perft.get();
            return perfTResult;
        }
        finally {
            exec.shutdown();
        }
    }

    PerfTBuilder<M> createBuilder() {
        return new PerfTBuilder();
    }

    @Override
    public void stop() {
        if (this.perft == null) {
            throw new IllegalStateException("Try to stop a non started task");
        }
        this.perft.interrupt();
    }
}

