/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.jchess.uci.extended;

import com.fathzer.games.MoveGenerator;
import com.fathzer.games.perft.FromPositionMoveGeneratorBuilder;
import com.fathzer.games.perft.MoveGeneratorChecker;
import com.fathzer.games.perft.PerfTResult;
import com.fathzer.games.perft.PerfTTestData;
import com.fathzer.jchess.uci.Engine;
import com.fathzer.jchess.uci.StoppableTask;
import com.fathzer.jchess.uci.UCI;
import com.fathzer.jchess.uci.extended.Displayable;
import com.fathzer.jchess.uci.extended.MoveGeneratorSupplier;
import com.fathzer.jchess.uci.extended.MoveToUCIConverter;
import com.fathzer.jchess.uci.extended.PerftTask;
import com.fathzer.jchess.uci.parameters.PerfStatsParameters;
import com.fathzer.jchess.uci.parameters.PerfTParameters;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Optional;
import java.util.Timer;
import java.util.TimerTask;

public class ExtendedUCI
extends UCI {
    private static final String PERFT_COMMAND = "perft";
    private static final String TEST_COMMAND = "test";
    private static final String NO_POSITION_DEFINED = "No position defined";

    public ExtendedUCI(Engine defaultEngine) {
        super(defaultEngine);
        this.addCommand(this::doPerft, PERFT_COMMAND, new String[0]);
        this.addCommand(this::doPerfStat, TEST_COMMAND, new String[0]);
        this.addCommand(this::doDisplay, "d", new String[0]);
    }

    protected void doDisplay(Deque<String> tokens) {
        if (!this.isPositionSet()) {
            this.debug(NO_POSITION_DEFINED);
            return;
        }
        Engine engine = this.engine;
        if (engine instanceof Displayable) {
            String result;
            Displayable displayable = (Displayable)((Object)engine);
            if (tokens.isEmpty()) {
                result = displayable.getBoardAsString();
            } else if (tokens.size() == 1 && "fen".equals(tokens.peek())) {
                result = ((Displayable)((Object)this.engine)).getFEN();
            } else {
                this.debug("Unknown display options " + Arrays.asList(tokens));
                return;
            }
            this.out(result);
        } else {
            this.debug("position display is not supported by this engine");
        }
    }

    protected void doPerft(Deque<String> tokens) {
        if (!this.isPositionSet()) {
            this.debug(NO_POSITION_DEFINED);
            return;
        }
        if (this.engine instanceof MoveGeneratorSupplier) {
            Optional<PerfTParameters> params = this.parse(PerfTParameters::new, PerfTParameters.PARSER, tokens);
            if (params.isPresent()) {
                this.launchPerfT(params.get());
            }
        } else {
            this.debug("perft is not supported by this engine");
        }
    }

    private <M> void launchPerfT(PerfTParameters params) {
        PerftTask task = new PerftTask(((MoveGeneratorSupplier)((Object)this.engine))::getMoveGenerator, params);
        if (!this.doBackground(() -> this.doPerft(task, params), task::stop, e -> this.err(PERFT_COMMAND, (Throwable)e))) {
            this.debug("Engine is already working");
        }
    }

    private <M> void doPerft(StoppableTask<PerfTResult<M>> task, PerfTParameters params) throws Exception {
        long start = System.currentTimeMillis();
        PerfTResult result = (PerfTResult)task.call();
        long duration = System.currentTimeMillis() - start;
        if (result.isInterrupted()) {
            this.out("perft process has been interrupted");
        } else {
            result.getDivides().stream().forEach(d -> this.out(this.toString(d.getMove()) + ": " + d.getNbLeaves()));
            long sum = result.getNbLeaves();
            this.out("perft " + ExtendedUCI.f(sum) + " leaves in " + ExtendedUCI.f(duration) + "ms (" + ExtendedUCI.f(sum * 1000L / duration) + " leaves/s) (using " + params.getParallelism() + " thread(s))");
            this.out("perft " + ExtendedUCI.f(result.getNbMovesFound()) + " " + (params.isLegal() ? "" : "peudo-") + "legal moves generated (" + ExtendedUCI.f(result.getNbMovesFound() * 1000L / duration) + " mv/s). " + ExtendedUCI.f(result.getNbMovesMade()) + " moves made (" + ExtendedUCI.f(result.getNbMovesMade() * 1000L / duration) + " mv/s)");
        }
    }

    private <M> String toString(M move) {
        return this.engine instanceof MoveToUCIConverter ? ((MoveToUCIConverter)((Object)this.engine)).toUCI(move).toString() : move.toString();
    }

    protected void doPerfStat(Deque<String> tokens) {
        if (!(this.engine instanceof FromPositionMoveGeneratorBuilder)) {
            this.debug("test is not supported by this engine");
            return;
        }
        Optional<PerfStatsParameters> params = this.parse(PerfStatsParameters::new, PerfStatsParameters.PARSER, tokens);
        if (params.isPresent()) {
            Collection<PerfTTestData> testData = this.readTestData();
            if (testData.isEmpty()) {
                this.out("No test data available");
                this.debug("You may override readTestData to read some data");
                return;
            }
            this.doPerfStat(testData, (FromPositionMoveGeneratorBuilder)((Object)this.engine), params.get());
        }
    }

    private <M, B extends MoveGenerator<M>> void doPerfStat(Collection<PerfTTestData> testData, FromPositionMoveGeneratorBuilder<M, B> engine, PerfStatsParameters params) {
        MoveGeneratorChecker test = new MoveGeneratorChecker(testData);
        test.setErrorManager(e -> this.err(TEST_COMMAND, (Throwable)e));
        test.setCountErrorManager(e -> this.out("Error for " + e.startPosition() + " expected " + e.expectedCount() + " got " + e.actualCount()));
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                ExtendedUCI.this.doStop(null);
            }
        };
        this.doBackground(() -> {
            Timer timer = new Timer();
            timer.schedule(task, 1000L * (long)params.getCutTime());
            try {
                long start = System.currentTimeMillis();
                long sum = test.run(engine, params.getDepth(), params.isLegal(), params.isPlayLeaves(), params.getParallelism());
                long duration = System.currentTimeMillis() - start;
                this.out("perf: " + ExtendedUCI.f(sum) + (params.isLegal() ? " " : " pseudo-") + "legal moves in " + ExtendedUCI.f(duration) + "ms (" + ExtendedUCI.f(sum * 1000L / duration) + " mv/s) (using " + params.getParallelism() + " thread(s) and " + (params.isPlayLeaves() || !params.isLegal() ? "" : "not ") + "playing leave moves)");
            }
            finally {
                timer.cancel();
            }
        }, test::interrupt, e -> this.err(TEST_COMMAND, (Throwable)e));
    }

    protected Collection<PerfTTestData> readTestData() {
        return Collections.emptyList();
    }

    private static String f(long num) {
        return NumberFormat.getInstance().format(num);
    }
}

