/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.jchess.uci;

import java.util.Objects;

public class UCIMove {
    private final String from;
    private final String to;
    private final String promotion;

    public UCIMove(String from, String to) {
        this(from, to, null);
    }

    public UCIMove(String from, String to, String promotion) {
        if (from == null || to == null) {
            throw new IllegalArgumentException();
        }
        this.from = from;
        this.to = to;
        this.promotion = promotion;
    }

    public static UCIMove from(String uci) {
        if (uci == null || uci.length() > 5) {
            throw new IllegalArgumentException();
        }
        try {
            String from = uci.substring(0, 2);
            String to = uci.substring(2, 4);
            return new UCIMove(from, to, uci.length() > 4 ? uci.substring(4, 5) : null);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public String getFrom() {
        return this.from;
    }

    public String getTo() {
        return this.to;
    }

    public String getPromotion() {
        return this.promotion;
    }

    public String toString() {
        return this.from + this.to + (this.promotion == null ? "" : this.promotion);
    }

    public int hashCode() {
        return Objects.hash(this.from, this.promotion, this.to);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UCIMove other = (UCIMove)obj;
        return this.from.equals(other.from) && this.to.equals(other.to) && Objects.equals(this.promotion, other.promotion);
    }
}

