/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.jchess.uci;

import com.fathzer.jchess.uci.UCIMove;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;

public class GoReply {
    private final UCIMove bestMove;
    private final UCIMove ponderMove;
    private Info info;

    public GoReply(UCIMove move) {
        this(move, null);
    }

    public GoReply(UCIMove move, UCIMove ponderMove) {
        this.bestMove = move;
        this.ponderMove = ponderMove;
    }

    public void setInfo(Info info) {
        this.info = info;
    }

    public Optional<UCIMove> getMove() {
        return Optional.ofNullable(this.bestMove);
    }

    public Optional<UCIMove> getPonderMove() {
        return Optional.ofNullable(this.ponderMove);
    }

    public Optional<Info> getInfo() {
        return Optional.ofNullable(this.info);
    }

    public String toString() {
        return "bestmove " + (this.bestMove == null ? "(none)" : this.bestMove) + (String)(this.ponderMove == null ? "" : " " + this.ponderMove);
    }

    public Optional<String> getMainInfoString() {
        return this.bestMove == null || this.info == null ? Optional.empty() : this.getInfoString(0);
    }

    public Optional<String> getInfoString(int index) {
        List<UCIMove> pv;
        UCIMove move;
        Optional<Score> score;
        if (index < 0 || this.info == null || index > this.info.extraMoves.size()) {
            throw new IllegalArgumentException();
        }
        StringBuilder builder = new StringBuilder();
        if (this.info.depth > 0) {
            builder.append("depth ").append(this.info.depth);
        }
        if ((score = this.info.getScore(move = index == 0 ? this.bestMove : this.info.extraMoves.get(index - 1))).isPresent()) {
            if (!builder.isEmpty()) {
                builder.append(' ');
            }
            builder.append("score ").append(score.get().toUCI());
        }
        if (this.info.hashFull > 0) {
            if (!builder.isEmpty()) {
                builder.append(' ');
            }
            builder.append("hashfull ").append(this.info.hashFull);
        }
        if ((pv = this.info.getPv(move)).isEmpty()) {
            pv = Collections.singletonList(move);
        }
        if (!builder.isEmpty()) {
            builder.append(' ');
        }
        String moves = String.join((CharSequence)" ", pv.stream().map(UCIMove::toString).toList());
        builder.append("multipv ").append(index + 1).append(" pv ").append(moves);
        return builder.isEmpty() ? Optional.empty() : Optional.of("info " + builder);
    }

    public static class Info {
        private final int depth;
        private List<UCIMove> extraMoves;
        private Function<UCIMove, List<UCIMove>> pvBuilder;
        private Function<UCIMove, Optional<Score>> scoreBuilder;
        private int hashFull;

        public Info(int depth) {
            this.depth = depth;
            this.extraMoves = Collections.emptyList();
            this.pvBuilder = Collections::singletonList;
            this.scoreBuilder = m -> Optional.empty();
            this.hashFull = -1;
        }

        public int getDepth() {
            return this.depth;
        }

        public int getHashFull() {
            return this.hashFull;
        }

        public void setHashFull(int hashFull) {
            this.hashFull = hashFull;
        }

        public List<UCIMove> getExtraMoves() {
            return this.extraMoves;
        }

        public List<UCIMove> getPv(UCIMove move) {
            return this.pvBuilder.apply(move);
        }

        public Optional<Score> getScore(UCIMove move) {
            return this.scoreBuilder.apply(move);
        }

        public void setExtraMoves(List<UCIMove> extraMoves) {
            this.extraMoves = extraMoves;
        }

        public void setPvBuilder(Function<UCIMove, List<UCIMove>> pvBuilder) {
            if (pvBuilder == null) {
                throw new IllegalArgumentException("pvBuilder cannot be null");
            }
            this.pvBuilder = pvBuilder;
        }

        public void setScoreBuilder(Function<UCIMove, Optional<Score>> scoreBuilder) {
            if (scoreBuilder == null) {
                throw new IllegalArgumentException("scoreBuilder cannot be null");
            }
            this.scoreBuilder = scoreBuilder;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Score {
        public String toUCI();
    }

    public record MateScore(int moveNumber) implements Score
    {
        @Override
        public String toUCI() {
            return "mate " + this.moveNumber;
        }
    }

    public record UpperScore(int cp) implements Score
    {
        @Override
        public String toUCI() {
            return "upperbound " + this.cp;
        }
    }

    public record LowerScore(int cp) implements Score
    {
        @Override
        public String toUCI() {
            return "lowerbound " + this.cp;
        }
    }

    public record CpScore(int cp) implements Score
    {
        @Override
        public String toUCI() {
            return "cp " + this.cp;
        }
    }
}

