/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.jchess.uci;

import com.fathzer.jchess.uci.GoReply;
import com.fathzer.jchess.uci.StoppableTask;
import com.fathzer.jchess.uci.UCIMove;
import com.fathzer.jchess.uci.UsualOptions;
import com.fathzer.jchess.uci.option.Option;
import com.fathzer.jchess.uci.parameters.GoParameters;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.AnnotatedType;
import java.util.HashMap;
import java.util.Map;

public interface Engine {
    default public String getId() {
        Id annotation = Engine.getAnnotation(this.getClass(), Id.class);
        if (annotation == null) {
            throw new IllegalStateException(Id.class + "annotation is missing on class " + this.getClass());
        }
        return annotation.value();
    }

    private static <T extends Annotation> T getAnnotation(Class<?> target, Class<T> annotationClass) {
        AnnotatedType type = target.getAnnotatedSuperclass();
        T annotation = type.getAnnotation(annotationClass);
        return annotation != null ? annotation : target.getAnnotation(annotationClass);
    }

    default public String getAuthor() {
        Author annotation = Engine.getAnnotation(this.getClass(), Author.class);
        return annotation == null ? null : annotation.value();
    }

    default public void newGame() {
    }

    default public int getDefaultHashTableSize() {
        return -1;
    }

    default public void setHashTableSize(int sizeInMB) {
        throw this.getDefaultHashTableSize() < 0 ? new UnsupportedOperationException() : new IllegalStateException();
    }

    default public void clearHashTable() {
        throw this.getDefaultHashTableSize() < 0 ? new UnsupportedOperationException() : new IllegalStateException();
    }

    default public boolean isChess960Supported() {
        return Engine.getAnnotation(this.getClass(), Chess960Supported.class) != null;
    }

    default public void setChess960(boolean chess960Mode) {
        throw this.isChess960Supported() ? new IllegalStateException() : new UnsupportedOperationException();
    }

    default public boolean hasOwnBook() {
        return false;
    }

    default public void setOwnBook(boolean activate) {
        throw this.hasOwnBook() ? new IllegalStateException() : new UnsupportedOperationException();
    }

    default public Map<String, Option<?>> getOptions() {
        HashMap options = new HashMap();
        if (this.isChess960Supported()) {
            options.put("UCI_Chess960", UsualOptions.chess960(this::setChess960));
        }
        if (this.hasOwnBook()) {
            options.put("OwnBook", UsualOptions.ownBook(this::setOwnBook, true));
        }
        if (this.getDefaultHashTableSize() >= 0) {
            options.put("Hash", UsualOptions.hash(this::setHashTableSize, this.getDefaultHashTableSize(), Math.min(this.getDefaultHashTableSize(), 1), 0x400000));
            options.put("Clear Hash", UsualOptions.clearHash(this::clearHashTable));
        }
        return options;
    }

    public void setStartPosition(String var1);

    public void move(UCIMove var1);

    public StoppableTask<GoReply> go(GoParameters var1);

    @Target(value={ElementType.TYPE, ElementType.TYPE_USE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Inherited
    public static @interface Id {
        public String value();
    }

    @Target(value={ElementType.TYPE, ElementType.TYPE_USE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Inherited
    public static @interface Author {
        public String value();
    }

    @Target(value={ElementType.TYPE, ElementType.TYPE_USE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Inherited
    public static @interface Chess960Supported {
    }
}

