/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.jchess.uci;

import com.fathzer.games.util.exec.CustomThreadFactory;
import com.fathzer.jchess.uci.ThrowingRunnable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;

class BackgroundTaskManager
implements AutoCloseable {
    private final ExecutorService exec = Executors.newFixedThreadPool(1, new CustomThreadFactory(() -> "Stoppable Tasks", true));
    private final AtomicReference<Task> current = new AtomicReference();

    BackgroundTaskManager() {
    }

    boolean doBackground(Task task) {
        boolean result = this.current.compareAndSet(null, task);
        if (result) {
            this.exec.submit(() -> {
                try {
                    task.run.run();
                    this.current.set(null);
                }
                catch (Exception e) {
                    task.logger.accept(e);
                    this.stop();
                }
            });
        }
        return result;
    }

    boolean stop() {
        Task stopTask = this.current.getAndSet(null);
        if (stopTask != null) {
            try {
                stopTask.stopTask.run();
            }
            catch (Exception e) {
                stopTask.logger.accept(e);
            }
        }
        return stopTask != null;
    }

    @Override
    public void close() {
        this.stop();
        this.exec.shutdown();
    }

    static class Task {
        private final Consumer<Exception> logger;
        private final ThrowingRunnable run;
        private final Runnable stopTask;

        Task(ThrowingRunnable task, Runnable stopTask, Consumer<Exception> logger) {
            this.run = task;
            this.stopTask = stopTask;
            this.logger = logger;
        }
    }
}

