/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.jchess.lichess;

import com.fathzer.games.MoveGenerator;
import com.fathzer.games.ai.evaluation.EvaluatedMove;
import com.fathzer.games.ai.evaluation.Evaluation;
import com.fathzer.games.movelibrary.AbstractMoveLibrary;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import java.util.zip.GZIPInputStream;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;

public abstract class AbstractDefaultOpenings<M, B extends MoveGenerator<M>>
extends AbstractMoveLibrary<JSONObject, M, B> {
    private final JSONObject db;

    protected AbstractDefaultOpenings(Supplier<InputStream> stream, boolean zipped) throws IOException {
        this.db = this.readJSON(stream, zipped);
        this.setMoveSelector(this.weightedMoveSelector());
    }

    private JSONObject readJSON(Supplier<InputStream> stream, boolean zipped) throws IOException {
        try (InputStream in = zipped ? new GZIPInputStream(stream.get()) : stream.get();){
            JSONObject jSONObject = new JSONObject(new JSONTokener(in));
            return jSONObject;
        }
    }

    private String toReducedXFen(B board) {
        String fen = this.toXFEN(board);
        int index = fen.lastIndexOf(32, fen.lastIndexOf(32) - 1);
        return fen.substring(0, index);
    }

    @Override
    protected List<JSONObject> getRecords(B board) {
        JSONArray moves;
        String fen = this.toReducedXFen(board);
        JSONObject theRecord = this.db.optJSONObject(fen);
        JSONArray jSONArray = moves = theRecord == null ? null : theRecord.optJSONArray("moves");
        if (moves == null) {
            return Collections.emptyList();
        }
        LinkedList<JSONObject> result = new LinkedList<JSONObject>();
        for (int i = 0; i < moves.length(); ++i) {
            result.add(moves.getJSONObject(i));
        }
        return result;
    }

    @Override
    protected EvaluatedMove<M> toEvaluatedMove(B board, JSONObject move) {
        return new EvaluatedMove<M>(this.fromUCI(board, this.getCoord(move)), Evaluation.UNKNOWN);
    }

    @Override
    protected long getWeight(JSONObject move) {
        return move.getLong("count");
    }

    protected String getCoord(JSONObject move) {
        return move.getString("coord");
    }

    protected abstract String toXFEN(B var1);

    protected abstract M fromUCI(B var1, String var2);
}

