/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.jchess.chesslib.uci;

import com.fathzer.games.movelibrary.MoveLibrary;
import com.fathzer.games.perft.PerfTParser;
import com.fathzer.games.perft.PerfTTestData;
import com.fathzer.jchess.chesslib.ChessLibMoveGenerator;
import com.fathzer.jchess.chesslib.uci.ChessLibEngine;
import com.fathzer.jchess.lichess.DefaultOpenings;
import com.fathzer.jchess.uci.Engine;
import com.fathzer.jchess.uci.extended.ExtendedUCI;
import com.fathzer.jchess.uci.extended.SpeedTest;
import com.fathzer.jchess.uci.helper.DeferredReadMoveLibrary;
import com.github.bhlangonijr.chesslib.move.Move;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main
extends ExtendedUCI {
    private static final Logger LOGGER = LoggerFactory.getLogger(Main.class);

    public static void main(String[] args) {
        String pathProperty = System.getProperty("openingsUrl");
        DeferredReadMoveLibrary<Move, ChessLibMoveGenerator> openings = pathProperty == null ? null : new DeferredReadMoveLibrary<Move, ChessLibMoveGenerator>(pathProperty, Main::readOpenings);
        try (Main uci = new Main(new ChessLibEngine(openings));){
            uci.run();
        }
    }

    public Main(Engine defaultEngine) {
        super(defaultEngine);
        this.addCommand(this::speedTest, "st", new String[0]);
    }

    @Override
    protected void doIsReady(Deque<String> tokens) {
        ChessLibEngine cle;
        DeferredReadMoveLibrary<Move, ChessLibMoveGenerator> book;
        Engine engine = this.engine;
        if (engine instanceof ChessLibEngine && (book = (cle = (ChessLibEngine)engine).getOwnBook()) != null && book.isInitRequired()) {
            LOGGER.debug("Start reading opening library from {}", (Object)book.getUrl());
            try {
                book.init();
                LOGGER.debug("Opening library read from {}", (Object)book.getUrl());
            }
            catch (IOException e) {
                LOGGER.error("Unable to load opening library at {}", (Object)book.getUrl(), (Object)e);
                this.debug("An error occurred while reading opening book");
            }
        }
        super.doIsReady(tokens);
    }

    static MoveLibrary<Move, ChessLibMoveGenerator> readOpenings(URL location) throws IOException {
        boolean compressed = location.getFile().endsWith(".gz");
        try (InputStream stream = location.openStream();){
            DefaultOpenings defaultOpenings = new DefaultOpenings(() -> stream, compressed);
            return defaultOpenings;
        }
    }

    @Override
    protected Collection<PerfTTestData> readTestData() {
        List<PerfTTestData> list;
        block8: {
            InputStream stream = Main.class.getResourceAsStream("/com/fathzer/jchess/perft/Perft.txt");
            try {
                list = new PerfTParser().withStartPositionPrefix("position fen").withStartPositionCustomizer(s -> s + " 0 1").read(stream, StandardCharsets.UTF_8);
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            stream.close();
        }
        return list;
    }

    private void speedTest(Deque<String> args) {
        Engine engine = this.engine;
        if (engine instanceof ChessLibEngine) {
            ChessLibEngine chesslibEngine = (ChessLibEngine)engine;
            this.out("completed in " + new SpeedTest<Move, ChessLibMoveGenerator>(chesslibEngine, x$0 -> this.out((CharSequence)x$0)).run() + "ms");
        } else {
            this.debug("This engine does not support this command");
        }
    }

    @Override
    protected void err(String tag, Throwable e) {
        LOGGER.error("An error occurred in {}", (Object)tag, (Object)e);
    }

    @Override
    protected void err(CharSequence message) {
        LOGGER.error("{}", (Object)message);
    }
}

