/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.jchess.chesslib.uci;

import com.fathzer.games.ai.Negamax;
import com.fathzer.games.ai.SearchContext;
import com.fathzer.games.ai.evaluation.EvaluatedMove;
import com.fathzer.games.ai.evaluation.Evaluator;
import com.fathzer.games.ai.iterativedeepening.DeepeningPolicy;
import com.fathzer.games.ai.iterativedeepening.FirstBestMoveSelector;
import com.fathzer.games.ai.iterativedeepening.IterativeDeepeningEngine;
import com.fathzer.games.ai.iterativedeepening.SearchHistory;
import com.fathzer.games.ai.moveselector.RandomMoveSelector;
import com.fathzer.games.ai.moveselector.StaticMoveSelector;
import com.fathzer.games.ai.time.BasicTimeManager;
import com.fathzer.games.ai.transposition.SizeUnit;
import com.fathzer.games.ai.transposition.TranspositionTable;
import com.fathzer.games.perft.FromPositionMoveGeneratorBuilder;
import com.fathzer.games.util.PhysicalCores;
import com.fathzer.games.util.exec.ExecutionContext;
import com.fathzer.jchess.chesslib.ChessLibMoveGenerator;
import com.fathzer.jchess.chesslib.ai.BasicMoveComparator;
import com.fathzer.jchess.chesslib.ai.BasicQuiesceSearch;
import com.fathzer.jchess.chesslib.ai.ChessLibDeepeningPolicy;
import com.fathzer.jchess.chesslib.ai.DefaultLogger;
import com.fathzer.jchess.chesslib.ai.TT;
import com.fathzer.jchess.chesslib.ai.eval.NaiveEvaluator;
import com.fathzer.jchess.chesslib.ai.eval.PestoEvaluator;
import com.fathzer.jchess.chesslib.ai.eval.SimplifiedEvaluator;
import com.fathzer.jchess.chesslib.time.RemainingMoveOracle;
import com.fathzer.jchess.uci.UCIMove;
import com.fathzer.jchess.uci.extended.Displayable;
import com.fathzer.jchess.uci.helper.AbstractEngine;
import com.fathzer.jchess.uci.helper.DeferredReadMoveLibrary;
import com.fathzer.jchess.uci.helper.EvaluatorConfiguration;
import com.github.bhlangonijr.chesslib.Board;
import com.github.bhlangonijr.chesslib.Piece;
import com.github.bhlangonijr.chesslib.Square;
import com.github.bhlangonijr.chesslib.move.Move;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;

public class ChessLibEngine
extends AbstractEngine<Move, ChessLibMoveGenerator>
implements FromPositionMoveGeneratorBuilder<Move, ChessLibMoveGenerator>,
Displayable {
    private static final List<EvaluatorConfiguration<Move, ChessLibMoveGenerator>> EVALUATORS = Arrays.asList(new EvaluatorConfiguration("pesto", PestoEvaluator::new), new EvaluatorConfiguration("simplified", SimplifiedEvaluator::new), new EvaluatorConfiguration("naive", NaiveEvaluator::new));
    private final DeferredReadMoveLibrary<Move, ChessLibMoveGenerator> ownBook;

    public ChessLibEngine() {
        this(null);
    }

    public ChessLibEngine(DeferredReadMoveLibrary<Move, ChessLibMoveGenerator> ownBook) {
        super(ChessLibEngine.buildEngine(EVALUATORS.get(0).evaluatorBuilder(), 20), new BasicTimeManager<ChessLibMoveGenerator>(RemainingMoveOracle.INSTANCE));
        this.setEvaluators(EVALUATORS);
        this.ownBook = ownBook;
    }

    @Override
    public String getId() {
        return "ChessLib";
    }

    @Override
    public String getAuthor() {
        return "Jean-Marc Astesana (Fathzer), Move generator is from Ben-Hur Carlos Vieira Langoni Junior";
    }

    DeferredReadMoveLibrary<Move, ChessLibMoveGenerator> getOwnBook() {
        return this.ownBook;
    }

    @Override
    public boolean hasOwnBook() {
        return this.ownBook != null;
    }

    @Override
    public void setOwnBook(boolean activate) {
        this.engine.setOpenings(activate ? this.ownBook : null);
    }

    @Override
    public void setStartPosition(String fen) {
        this.board = this.fromPosition(fen);
        ((ChessLibMoveGenerator)this.board).setMoveComparatorBuilder(BasicMoveComparator::new);
    }

    @Override
    public UCIMove toUCI(Move move) {
        String fenSymbol = Piece.NONE.equals((Object)move.getPromotion()) ? null : move.getPromotion().getFenSymbol().toLowerCase();
        return new UCIMove(move.getFrom().name().toLowerCase(), move.getTo().name().toLowerCase(), fenSymbol);
    }

    @Override
    protected Move toMove(UCIMove move) {
        return ChessLibEngine.fromUCI(move, (ChessLibMoveGenerator)this.board);
    }

    public static Move fromUCI(UCIMove move, ChessLibMoveGenerator board) {
        Piece p = null;
        String promotion = move.getPromotion();
        if (promotion != null) {
            String notation = board.isWhiteToMove() ? promotion.toUpperCase() : promotion;
            p = Piece.fromFenSymbol(notation);
        } else {
            p = Piece.NONE;
        }
        return new Move(Square.fromValue(move.getFrom().toUpperCase()), Square.fromValue(move.getTo().toUpperCase()), p);
    }

    @Override
    public String getBoardAsString() {
        return ((ChessLibMoveGenerator)this.board).getBoard().toString();
    }

    @Override
    public String getFEN() {
        return this.board == null ? null : ((ChessLibMoveGenerator)this.board).getBoard().getFen();
    }

    @Override
    public ChessLibMoveGenerator fromPosition(String fen) {
        Board internalBoard = new Board();
        internalBoard.loadFromFen(fen);
        return new ChessLibMoveGenerator(internalBoard);
    }

    public static IterativeDeepeningEngine<Move, ChessLibMoveGenerator> buildEngine(Supplier<Evaluator<Move, ChessLibMoveGenerator>> evaluatorBuilder, int maxDepth) {
        IterativeDeepeningEngine<Move, ChessLibMoveGenerator> engine = new IterativeDeepeningEngine<Move, ChessLibMoveGenerator>((DeepeningPolicy)new ChessLibDeepeningPolicy(maxDepth), (TranspositionTable)new TT(16, SizeUnit.MB), evaluatorBuilder){

            @Override
            protected Negamax<Move, ChessLibMoveGenerator> buildAI(ExecutionContext<SearchContext<Move, ChessLibMoveGenerator>> context) {
                Negamax negaMax = (Negamax)super.buildAI(context);
                negaMax.setQuiesceEvaluator(new BasicQuiesceSearch());
                return negaMax;
            }
        };
        engine.setLogger(new DefaultLogger(engine));
        engine.setParallelism(PhysicalCores.count() > 1 ? 2 : 1);
        engine.getDeepeningPolicy().setMaxTime(60000L);
        return engine;
    }

    @Override
    protected EvaluatedMove<Move> getSelected(ChessLibMoveGenerator b, SearchHistory<Move> history) {
        BasicMoveComparator c = new BasicMoveComparator(b);
        StaticMoveSelector stmv = new StaticMoveSelector(c::evaluate);
        FirstBestMoveSelector selector = new FirstBestMoveSelector();
        selector.setNext(stmv.setNext(new RandomMoveSelector()));
        return history.getBestMove(selector);
    }

    @Override
    protected TranspositionTable<Move, ChessLibMoveGenerator> buildTranspositionTable(int sizeInMB) {
        return new TT(sizeInMB, SizeUnit.MB);
    }
}

