/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.jchess.chesslib.ai;

import com.fathzer.games.ai.transposition.OneLongEntryTranspositionTable;
import com.fathzer.games.ai.transposition.SizeUnit;
import com.fathzer.jchess.chesslib.ChessLibMoveGenerator;
import com.github.bhlangonijr.chesslib.Piece;
import com.github.bhlangonijr.chesslib.Square;
import com.github.bhlangonijr.chesslib.move.Move;

public class TT
extends OneLongEntryTranspositionTable<Move, ChessLibMoveGenerator> {
    private static final int FROM_MASK = 4095;
    private static final int TO_MASK = 0xFFF000;
    private static final int TO_OFFSET = 12;
    private static final int PROMOTION_OFFSET = 24;

    public TT(int size, SizeUnit unit) {
        super(size, unit);
    }

    @Override
    protected int toInt(Move move) {
        if (move == null) {
            return 0;
        }
        int result = move.getFrom().ordinal() | move.getTo().ordinal() << 12;
        if (move.getPromotion() != null) {
            result |= move.getPromotion().ordinal() << 24;
        }
        return result;
    }

    @Override
    protected Move toMove(int value) {
        if (value == 0) {
            return null;
        }
        int promotionIndex = value >> 24;
        Square from = Square.squareAt(value & 0xFFF);
        Square to = Square.squareAt((value & 0xFFF000) >> 12);
        return promotionIndex == 0 ? new Move(from, to) : new Move(from, to, Piece.allPieces[promotionIndex]);
    }
}

