/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.jchess.chesslib.ai;

import com.fathzer.chess.utils.evaluators.quiesce.AbstractBasicQuiesceEvaluator;
import com.fathzer.games.ai.SearchContext;
import com.fathzer.jchess.chesslib.ChessLibMoveGenerator;
import com.fathzer.jchess.chesslib.ai.BasicMoveComparator;
import com.github.bhlangonijr.chesslib.Board;
import com.github.bhlangonijr.chesslib.move.Move;
import java.util.List;

public class BasicQuiesceSearch
extends AbstractBasicQuiesceEvaluator<Move, ChessLibMoveGenerator> {
    @Override
    protected List<Move> getMoves(SearchContext<Move, ChessLibMoveGenerator> context, int quiesceDepth) {
        ChessLibMoveGenerator gamePosition = context.getGamePosition();
        Board board = gamePosition.getBoard();
        List<Move> moves = board.isKingAttacked() ? board.pseudoLegalMoves() : board.pseudoLegalCaptures();
        moves.sort(new BasicMoveComparator(gamePosition));
        return moves;
    }

    @Override
    protected boolean isCheck(SearchContext<Move, ChessLibMoveGenerator> context) {
        return context.getGamePosition().getBoard().isKingAttacked();
    }
}

