/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.jchess.chesslib;

import com.fathzer.games.HashProvider;
import com.fathzer.games.MoveGenerator;
import com.fathzer.games.Status;
import com.fathzer.games.util.MoveList;
import com.fathzer.games.util.SelectiveComparator;
import com.github.bhlangonijr.chesslib.Board;
import com.github.bhlangonijr.chesslib.Side;
import com.github.bhlangonijr.chesslib.move.Move;
import java.util.List;
import java.util.function.Function;

public class ChessLibMoveGenerator
implements MoveGenerator<Move>,
HashProvider {
    private final Board board;
    private Function<ChessLibMoveGenerator, SelectiveComparator<Move>> moveComparatorBuilder;
    private SelectiveComparator<Move> comparator;

    public ChessLibMoveGenerator(Board board) {
        this.board = board;
    }

    @Override
    public boolean isWhiteToMove() {
        return this.board.getSideToMove() == Side.WHITE;
    }

    @Override
    public boolean makeMove(Move move, MoveGenerator.MoveConfidence confidence) {
        try {
            return this.board.doMove(move, MoveGenerator.MoveConfidence.UNSAFE == confidence);
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    @Override
    public void unmakeMove() {
        this.board.undoMove();
    }

    @Override
    public List<Move> getMoves() {
        List<Move> moves = this.board.pseudoLegalMoves();
        if (this.comparator == null) {
            return moves;
        }
        MoveList<Move> ml = new MoveList<Move>(moves, this.comparator);
        ml.sort();
        return ml;
    }

    @Override
    public List<Move> getLegalMoves() {
        return this.board.legalMoves();
    }

    @Override
    public long getHashKey() {
        return this.board.getZobristKey();
    }

    public Board getBoard() {
        return this.board;
    }

    public void setMoveComparatorBuilder(Function<ChessLibMoveGenerator, SelectiveComparator<Move>> moveComparatorBuilder) {
        this.moveComparatorBuilder = moveComparatorBuilder;
        this.comparator = moveComparatorBuilder == null ? null : moveComparatorBuilder.apply(this);
    }

    @Override
    public Status getContextualStatus() {
        return this.board.getHalfMoveCounter() >= 100 || this.board.isInsufficientMaterial() || this.board.isRepetition() ? Status.DRAW : Status.PLAYING;
    }

    @Override
    public Status getEndGameStatus() {
        if (this.board.isKingAttacked()) {
            return this.board.getSideToMove() == Side.BLACK ? Status.WHITE_WON : Status.BLACK_WON;
        }
        return Status.DRAW;
    }

    @Override
    public MoveGenerator<Move> fork() {
        ChessLibMoveGenerator result = new ChessLibMoveGenerator(this.board.clone());
        result.setMoveComparatorBuilder(this.moveComparatorBuilder);
        return result;
    }
}

