/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.jchess.chesslib;

import com.fathzer.chess.utils.adapters.MoveData;
import com.fathzer.jchess.chesslib.ChessLibBoardExplorer;
import com.fathzer.jchess.chesslib.ChessLibMoveGenerator;
import com.github.bhlangonijr.chesslib.CastleRight;
import com.github.bhlangonijr.chesslib.Piece;
import com.github.bhlangonijr.chesslib.PieceType;
import com.github.bhlangonijr.chesslib.Side;
import com.github.bhlangonijr.chesslib.Square;
import com.github.bhlangonijr.chesslib.game.GameContext;
import com.github.bhlangonijr.chesslib.move.Move;

public class ChessLibMoveData
implements MoveData<Move, ChessLibMoveGenerator> {
    private Square movingIndex;
    private Piece movingPiece;
    private Square movingDestination;
    private Square capturedIndex;
    private PieceType captured;
    private PieceType promotion;
    private Square castlingRookIndex;
    private Square castlingRookDestinationIndex;

    @Override
    public int getMovingIndex() {
        return this.getIndex(this.movingIndex);
    }

    @Override
    public int getMovingPiece() {
        return ChessLibBoardExplorer.toPiece(this.movingPiece);
    }

    @Override
    public int getMovingDestination() {
        return this.getIndex(this.movingDestination);
    }

    @Override
    public int getCapturedType() {
        return ChessLibBoardExplorer.fromPieceType(this.captured);
    }

    @Override
    public int getCapturedIndex() {
        return this.getIndex(this.capturedIndex);
    }

    @Override
    public int getPromotionType() {
        return ChessLibBoardExplorer.fromPieceType(this.promotion);
    }

    @Override
    public int getCastlingRookIndex() {
        return this.castlingRookIndex == null ? -1 : this.getIndex(this.castlingRookIndex);
    }

    @Override
    public int getCastlingRookDestinationIndex() {
        return this.getIndex(this.castlingRookDestinationIndex);
    }

    @Override
    public boolean update(Move move, ChessLibMoveGenerator board) {
        this.movingIndex = move.getFrom();
        this.movingPiece = board.getBoard().getPiece(this.movingIndex);
        PieceType movingType = this.movingPiece.getPieceType();
        if (movingType == null) {
            return false;
        }
        if (movingType == PieceType.KING) {
            this.promotion = null;
            GameContext context = board.getBoard().getContext();
            if (context.isCastleMove(move)) {
                Side side = board.getBoard().getSideToMove();
                this.captured = null;
                this.movingDestination = move.getTo();
                Move rookMove = context.getRookCastleMove(side, context.isKingSideCastle(move) ? CastleRight.KING_SIDE : CastleRight.QUEEN_SIDE);
                this.castlingRookIndex = rookMove.getFrom();
                this.castlingRookDestinationIndex = rookMove.getTo();
            } else {
                this.castlingRookIndex = null;
                this.movingDestination = move.getTo();
                this.captured = board.getBoard().getPiece(this.movingDestination).getPieceType();
                if (this.captured != null) {
                    this.capturedIndex = this.movingDestination;
                }
            }
        } else {
            this.castlingRookIndex = null;
            this.movingDestination = move.getTo();
            if (movingType == PieceType.PAWN && this.movingDestination == board.getBoard().getEnPassant()) {
                this.captured = PieceType.PAWN;
                this.capturedIndex = board.getBoard().getEnPassantTarget();
                this.promotion = null;
            } else {
                this.promotion = move.getPromotion().getPieceType();
                this.captured = board.getBoard().getPiece(this.movingDestination).getPieceType();
                if (this.captured != null) {
                    this.capturedIndex = this.movingDestination;
                }
            }
        }
        return true;
    }

    int getIndex(Square sq) {
        return 8 * (7 - sq.getRank().ordinal()) + sq.getFile().ordinal();
    }
}

