/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.jchess.chesslib;

import com.fathzer.chess.utils.adapters.BoardExplorer;
import com.github.bhlangonijr.chesslib.Board;
import com.github.bhlangonijr.chesslib.Piece;
import com.github.bhlangonijr.chesslib.PieceType;
import com.github.bhlangonijr.chesslib.Side;
import com.github.bhlangonijr.chesslib.Square;

class ChessLibBoardExplorer
implements BoardExplorer {
    static final Square[] SQUARES = new Square[]{Square.A8, Square.B8, Square.C8, Square.D8, Square.E8, Square.F8, Square.G8, Square.H8, Square.A7, Square.B7, Square.C7, Square.D7, Square.E7, Square.F7, Square.G7, Square.H7, Square.A6, Square.B6, Square.C6, Square.D6, Square.E6, Square.F6, Square.G6, Square.H6, Square.A5, Square.B5, Square.C5, Square.D5, Square.E5, Square.F5, Square.G5, Square.H5, Square.A4, Square.B4, Square.C4, Square.D4, Square.E4, Square.F4, Square.G4, Square.H4, Square.A3, Square.B3, Square.C3, Square.D3, Square.E3, Square.F3, Square.G3, Square.H3, Square.A2, Square.B2, Square.C2, Square.D2, Square.E2, Square.F2, Square.G2, Square.H2, Square.A1, Square.B1, Square.C1, Square.D1, Square.E1, Square.F1, Square.G1, Square.H1};
    private final Board board;
    private int index;
    private int piece;

    ChessLibBoardExplorer(Board board) {
        this.board = board;
        this.index = -1;
        this.next();
    }

    @Override
    public boolean next() {
        ++this.index;
        if (this.index >= SQUARES.length) {
            return false;
        }
        this.piece = ChessLibBoardExplorer.toPiece(this.board.getPiece(SQUARES[this.index]));
        return this.piece != 0 || this.next();
    }

    static int fromPieceType(PieceType type) {
        return type == null ? 0 : type.ordinal() + 1;
    }

    static int toPiece(Piece piece) {
        int index = ChessLibBoardExplorer.fromPieceType(piece.getPieceType());
        return piece.getPieceSide() == Side.WHITE ? index : -index;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public int getPiece() {
        return this.piece;
    }
}

