/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.jchess.chesslib;

import com.fathzer.jchess.chesslib.ChessLibMoveGenerator;
import com.github.bhlangonijr.chesslib.Piece;
import com.github.bhlangonijr.chesslib.PieceType;
import com.github.bhlangonijr.chesslib.Side;
import com.github.bhlangonijr.chesslib.Square;
import com.github.bhlangonijr.chesslib.move.Move;

public final class BasicMoveDecoder {
    private BasicMoveDecoder() {
    }

    public static int getMovingPiece(ChessLibMoveGenerator board, Move move) {
        return BasicMoveDecoder.toPiece(board.getBoard().getPiece(move.getFrom()));
    }

    public static int getCapturedType(ChessLibMoveGenerator board, Move move) {
        Piece moving = board.getBoard().getPiece(move.getFrom());
        if (Square.NONE != board.getBoard().getEnPassantTarget() && PieceType.PAWN == moving.getPieceType() && move.getTo().getFile() != move.getFrom().getFile()) {
            return 1;
        }
        Piece piece = board.getBoard().getPiece(move.getTo());
        return piece.getPieceSide() != moving.getPieceSide() ? BasicMoveDecoder.fromPieceType(piece.getPieceType()) : 0;
    }

    public static int getPromotionType(ChessLibMoveGenerator board, Move move) {
        return BasicMoveDecoder.fromPieceType(move.getPromotion().getPieceType());
    }

    private static int fromPieceType(PieceType type) {
        return type == null ? 0 : type.ordinal() + 1;
    }

    private static int toPiece(Piece piece) {
        int p = BasicMoveDecoder.fromPieceType(piece.getPieceType());
        return piece.getPieceSide() == Side.WHITE ? p : -p;
    }
}

