/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.games.util.exec;

import com.fathzer.games.util.exec.ContextualizedExecutor;
import com.fathzer.games.util.exec.ExecutionContext;
import com.fathzer.games.util.exec.Forkable;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;

class MultiThreadsContext<T extends Forkable<T>>
implements ExecutionContext<T> {
    protected final ContextualizedExecutor<T> exec;
    private final T globalContext;

    MultiThreadsContext(T context, ContextualizedExecutor<T> exec) {
        this.exec = exec;
        this.globalContext = context;
    }

    @Override
    public T getContext() {
        T result = this.exec.getContext();
        if (result == null) {
            return this.globalContext;
        }
        return result;
    }

    @Override
    public void execute(Collection<Runnable> tasks) {
        List callables = tasks.stream().map(this::toCallable).toList();
        try {
            List futures = this.exec.invokeAll(callables, this.globalContext);
            this.exec.checkExceptions(futures);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private Callable<Void> toCallable(Runnable task) {
        return () -> {
            task.run();
            return null;
        };
    }

    @Override
    public void close() {
        this.exec.close();
    }
}

