/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.games.util.exec;

import com.fathzer.games.util.exec.ContextualizedExecutor;
import com.fathzer.games.util.exec.Forkable;
import com.fathzer.games.util.exec.MultiThreadsContext;
import com.fathzer.games.util.exec.SingleThreadContext;
import java.util.Collection;

public interface ExecutionContext<T>
extends AutoCloseable {
    public T getContext();

    public void execute(Collection<Runnable> var1);

    @Override
    default public void close() {
    }

    public static <T extends Forkable<T>> ExecutionContext<T> get(int parallelism, T context) {
        if (parallelism < 1 || context == null) {
            throw new IllegalArgumentException();
        }
        if (parallelism == 1) {
            return new SingleThreadContext<T>(context);
        }
        ContextualizedExecutor exec = new ContextualizedExecutor(parallelism);
        return new MultiThreadsContext<T>(context, exec);
    }
}

