/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.games.util.exec;

import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;

public class CustomThreadFactory
implements ThreadFactory {
    private final Supplier<String> threadNameSupplier;
    private final boolean isDaemon;

    public CustomThreadFactory(Supplier<String> threadNameSupplier, boolean isDaemon) {
        this.threadNameSupplier = threadNameSupplier;
        this.isDaemon = isDaemon;
    }

    @Override
    public Thread newThread(Runnable runnable) {
        Thread thread = Executors.defaultThreadFactory().newThread(runnable);
        thread.setName(this.threadNameSupplier.get());
        if (this.isDaemon) {
            thread.setDaemon(true);
        }
        return thread;
    }

    public static class BasicThreadNameSupplier
    implements Supplier<String> {
        private final AtomicLong count;
        private final String prefix;

        public BasicThreadNameSupplier(String prefix) {
            this.prefix = prefix;
            this.count = new AtomicLong();
        }

        @Override
        public String get() {
            return this.prefix + " " + this.count.incrementAndGet();
        }
    }
}

