/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.games.util.exec;

import com.fathzer.games.util.PhysicalCores;
import com.fathzer.games.util.UncheckedException;
import com.fathzer.games.util.exec.Forkable;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;

class ContextualizedExecutor<T extends Forkable<T>>
implements AutoCloseable {
    private final AtomicBoolean running = new AtomicBoolean();
    private final ExecutorService exec;
    private final List<ContextThread<T>> threads = new LinkedList<ContextThread<T>>();
    private T masterContext;

    ContextualizedExecutor() {
        this(PhysicalCores.count());
    }

    ContextualizedExecutor(int parallelism) {
        this.exec = Executors.newFixedThreadPool(parallelism, r -> {
            ContextThread contextThread = new ContextThread(r);
            this.threads.add(contextThread);
            contextThread.context = this.masterContext.fork();
            return contextThread;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> List<Future<V>> invokeAll(Collection<Callable<V>> tasks, T context) throws InterruptedException {
        if (this.running.compareAndSet(false, true)) {
            try {
                this.masterContext = context;
                this.threads.forEach(t -> {
                    t.context = context.fork();
                });
                List<Future<V>> list = this.exec.invokeAll(tasks);
                return list;
            }
            finally {
                this.running.set(false);
            }
        }
        throw new IllegalStateException();
    }

    public <V> void checkExceptions(Collection<Future<V>> futures) throws InterruptedException {
        try {
            for (Future<V> future : futures) {
                future.get();
            }
        }
        catch (ExecutionException e) {
            throw new UncheckedException(e.getCause());
        }
    }

    public T getContext() {
        Thread currentThread = Thread.currentThread();
        return (T)(currentThread instanceof ContextThread ? (Forkable)((ContextThread)currentThread).context : null);
    }

    @Override
    public void close() {
        this.exec.shutdown();
    }

    private static class ContextThread<T>
    extends Thread {
        T context;

        public ContextThread(Runnable target) {
            super(target);
        }
    }
}

