/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.games.util;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Supplier;

public class Stack<T> {
    private final Supplier<T> builder;
    private final List<T> backups;
    private int index;
    private T current;

    public Stack(Supplier<T> builder) {
        this.builder = builder;
        this.backups = new ArrayList<T>();
        this.index = 0;
        this.current = null;
    }

    public T get() {
        if (this.current == null) {
            if (this.index >= this.backups.size()) {
                this.current = this.builder.get();
                this.backups.add(this.current);
            } else {
                this.current = this.backups.get(this.index);
            }
        }
        return this.current;
    }

    public void set(T element) {
        this.current = element;
        if (this.index >= this.backups.size()) {
            this.backups.add(this.current);
        } else {
            this.backups.set(this.index, this.current);
        }
    }

    public void next() {
        ++this.index;
        this.current = null;
    }

    public void previous() {
        if (this.index == 0) {
            throw new NoSuchElementException();
        }
        --this.index;
        this.current = this.backups.get(this.index);
    }

    public void clear() {
        this.backups.clear();
        this.index = 0;
        this.current = null;
    }
}

