/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.games.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public final class PhysicalCores {
    private static final NumberOfCores CORES = PhysicalCores.findPhysicalCoreCount();

    private PhysicalCores() {
    }

    public static int count() {
        if (PhysicalCores.CORES.e != null) {
            throw PhysicalCores.CORES.e;
        }
        return PhysicalCores.CORES.count;
    }

    private static NumberOfCores findPhysicalCoreCount() {
        String osName;
        try {
            osName = System.getProperty("os.name");
        }
        catch (SecurityException e) {
            return new NumberOfCores(new UnavailableException("Could not read system property 'os.name'", e));
        }
        try {
            if (osName == null) {
                throw new UnsupportedOperationException("Failed to read OS name.");
            }
            if (PhysicalCores.isLinux(osName)) {
                return PhysicalCores.readFromProc();
            }
            if (PhysicalCores.isWindows(osName)) {
                return PhysicalCores.readFromWMIC();
            }
            if (PhysicalCores.isMacOsX(osName)) {
                return PhysicalCores.readFromSysctlOsX();
            }
            if (PhysicalCores.isFreeBsd(osName)) {
                return PhysicalCores.readFromSysctlFreeBSD();
            }
            return new NumberOfCores(String.format("Unknown OS '%s'. Please report this so a case can be added.", osName));
        }
        catch (UnavailableException e) {
            return new NumberOfCores(e);
        }
    }

    private static NumberOfCores readFromProc() {
        NumberOfCores numberOfCores;
        String path = "/proc/cpuinfo";
        File cpuinfo = new File("/proc/cpuinfo");
        if (!cpuinfo.exists()) {
            return new NumberOfCores(String.format("Old Linux without %s. Will not be able to provide core count.", "/proc/cpuinfo"));
        }
        FileInputStream in = new FileInputStream(cpuinfo);
        try {
            String s = PhysicalCores.readToString(in, StandardCharsets.UTF_8);
            HashMap physicalIdToCoreId = new HashMap();
            int coreIdCount = 0;
            String[] split = s.split("\n");
            String latestPhysicalId = null;
            for (String row : split) {
                if (row.startsWith("physical id")) {
                    latestPhysicalId = row;
                    if (physicalIdToCoreId.get(row) != null) continue;
                    physicalIdToCoreId.put(latestPhysicalId, new HashSet());
                    continue;
                }
                if (!row.startsWith("core id")) continue;
                ((Set)physicalIdToCoreId.get(latestPhysicalId)).add(row);
            }
            for (Set coreIds : physicalIdToCoreId.values()) {
                coreIdCount += coreIds.size();
            }
            numberOfCores = new NumberOfCores(coreIdCount);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)in).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | SecurityException e) {
                return new NumberOfCores(String.format("Error %s while reading %s", e, "/proc/cpuinfo"));
            }
        }
        ((InputStream)in).close();
        return numberOfCores;
    }

    private static NumberOfCores readFromWMIC() {
        NumberOfCores numberOfCores;
        block11: {
            Process wmicProc;
            String wmic = System.getenv("windir") + "\\system32\\wbem\\WMIC";
            ProcessBuilder pb = new ProcessBuilder(wmic, "/OUTPUT:STDOUT", "CPU", "Get", "/Format:List");
            pb.redirectErrorStream(true);
            try {
                wmicProc = pb.start();
                wmicProc.getOutputStream().close();
            }
            catch (IOException | SecurityException e) {
                return new NumberOfCores(String.format("Failed to spawn WMIC process. Will not be able to provide physical core count: %s", e));
            }
            PhysicalCores.waitFor(wmicProc);
            InputStream in = wmicProc.getInputStream();
            try {
                String wmicOutput = PhysicalCores.readToString(in, StandardCharsets.US_ASCII);
                numberOfCores = PhysicalCores.parseWmicOutput(wmicOutput);
                if (in == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (UnsupportedEncodingException e) {
                    throw new UncheckedIOException(e);
                }
                catch (IOException | SecurityException e) {
                    return new NumberOfCores(String.format("Error while reading WMIC output file: %s", e));
                }
            }
            in.close();
        }
        return numberOfCores;
    }

    private static NumberOfCores parseWmicOutput(String wmicOutput) {
        String[] rows = wmicOutput.split("\n");
        int coreCount = 0;
        for (String row : rows) {
            if (!row.startsWith("NumberOfCores")) continue;
            String num = row.split("=")[1].trim();
            try {
                coreCount += Integer.parseInt(num);
            }
            catch (NumberFormatException e) {
                return new NumberOfCores(new UnavailableException(String.format("Unexpected output from WMIC: \"{}\". Will not be able to provide physical core count.", wmicOutput), e));
            }
        }
        return coreCount > 0 ? new NumberOfCores(coreCount) : new NumberOfCores(String.format("WMIC returned a negative of null number of cores (%d)", coreCount));
    }

    private static NumberOfCores readFromSysctlOsX() {
        String result = PhysicalCores.readSysctl("hw.physicalcpu", "-n");
        if (result == null) {
            return new NumberOfCores("sysctl hw.physicalcpu -n returned no data");
        }
        try {
            return new NumberOfCores(Integer.parseInt(result));
        }
        catch (NumberFormatException e) {
            return new NumberOfCores(String.format("sysctl returned something that was not a number: '%s'", result));
        }
    }

    private static NumberOfCores readFromSysctlFreeBSD() {
        String result = PhysicalCores.readSysctl("dev.cpu", new String[0]);
        if (result == null) {
            return null;
        }
        HashSet<String> cpuLocations = new HashSet<String>();
        for (String row : result.split("\n")) {
            if (!row.contains("location")) continue;
            cpuLocations.add(row.split("\\\\")[1]);
        }
        return cpuLocations.isEmpty() ? new NumberOfCores("sysctl dev.cpu returns no cores") : new NumberOfCores(cpuLocations.size());
    }

    private static String readSysctl(String variable, String ... options) {
        String result;
        Process sysctlProc;
        ArrayList<String> command = new ArrayList<String>();
        command.add("sysctl");
        command.addAll(Arrays.asList(options));
        command.add(variable);
        ProcessBuilder pb = new ProcessBuilder(command);
        pb.redirectErrorStream(true);
        try {
            sysctlProc = pb.start();
        }
        catch (IOException | SecurityException e) {
            throw new UnavailableException("Failed to spawn sysctl process. Will not be able to provide physical core count.", e);
        }
        try {
            result = PhysicalCores.readToString(sysctlProc.getInputStream(), StandardCharsets.UTF_8).trim();
        }
        catch (UnsupportedEncodingException e) {
            throw new UncheckedIOException(e);
        }
        catch (IOException e) {
            throw new UnavailableException("Error while reading from sysctl process", e);
        }
        int exitStatus = PhysicalCores.waitFor(sysctlProc);
        if (exitStatus != 0) {
            throw new UnavailableException(String.format("Could not read sysctl variable %s. Exit status was %s", variable, exitStatus));
        }
        return result;
    }

    private static boolean isLinux(String osName) {
        return osName.startsWith("Linux") || osName.startsWith("LINUX");
    }

    private static boolean isWindows(String osName) {
        return osName.startsWith("Windows");
    }

    private static boolean isMacOsX(String osName) {
        return osName.startsWith("Mac OS X");
    }

    private static boolean isFreeBsd(String osName) {
        return osName.startsWith("FreeBSD");
    }

    private static String readToString(InputStream in, Charset charset) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(in, charset);){
            StringWriter sw = new StringWriter();
            char[] buf = new char[10000];
            while (reader.read(buf) != -1) {
                sw.write(buf);
            }
            String string = sw.toString();
            return string;
        }
    }

    private static int waitFor(Process proc) {
        try {
            return proc.waitFor();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UnavailableException("Interrupted while waiting for process", e);
        }
    }

    private static class NumberOfCores {
        private final UnavailableException e;
        private final int count;

        private NumberOfCores(int count) {
            this.e = null;
            this.count = count;
        }

        private NumberOfCores(String message) {
            this(new UnavailableException(message));
        }

        private NumberOfCores(UnavailableException e) {
            this.e = e;
            this.count = -1;
        }
    }

    public static class UnavailableException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        private UnavailableException(String message, Throwable cause) {
            super(message, cause);
        }

        private UnavailableException(String message) {
            super(message);
        }
    }
}

