/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.games.util;

import com.fathzer.games.util.DualListIterator;
import com.fathzer.games.util.SelectiveComparator;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class MoveList<E>
extends AbstractList<E> {
    private final List<E> toBeSorted = new ArrayList();
    private final List<E> list;
    private SelectiveComparator<E> comparator;

    public static final <T> SelectiveComparator<T> noSort() {
        return NoSort.NO_SORT;
    }

    public MoveList() {
        this.list = new ArrayList();
        this.comparator = MoveList.noSort();
    }

    public MoveList(List<E> moves, SelectiveComparator<E> comparator) {
        this.list = moves;
        this.setComparator(comparator);
    }

    public void setComparator(SelectiveComparator<E> comparator) {
        SelectiveComparator<Object> selectiveComparator = this.comparator = comparator == null ? MoveList.noSort() : comparator;
        if (!this.isEmpty()) {
            this.list.addAll(this.toBeSorted);
            this.toBeSorted.clear();
            ListIterator<E> iter = this.list.listIterator();
            while (iter.hasNext()) {
                E m = iter.next();
                if (!this.comparator.test(m)) continue;
                this.toBeSorted.add(m);
                iter.remove();
            }
        }
    }

    @Override
    public boolean add(E e) {
        return this.comparator.test(e) ? this.toBeSorted.add(e) : this.list.add(e);
    }

    @Override
    public E get(int index) {
        return index < this.toBeSorted.size() ? this.toBeSorted.get(index) : this.list.get(index - this.toBeSorted.size());
    }

    @Override
    public int size() {
        return this.toBeSorted.size() + this.list.size();
    }

    @Override
    public void clear() {
        this.list.clear();
        this.toBeSorted.clear();
    }

    public void sort() {
        this.toBeSorted.sort(this.comparator);
    }

    @Override
    public Iterator<E> iterator() {
        return this.toBeSorted.isEmpty() ? this.list.iterator() : new DualListIterator<E>(this.toBeSorted, this.list);
    }

    private static class NoSort<T>
    implements SelectiveComparator<T> {
        private static final SelectiveComparator NO_SORT = new NoSort();

        private NoSort() {
        }

        @Override
        public int compare(T o1, T o2) {
            return 0;
        }

        @Override
        public boolean test(T t) {
            return false;
        }
    }
}

