/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.games.perft;

import com.fathzer.games.perft.PerfTTestData;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.function.UnaryOperator;

public class PerfTParser {
    private String startPositionPrefix = "start";
    private String resultPrefix = "perft";
    private String namePrefix = "name";
    private UnaryOperator<String> startPositionCustomizer = s -> s;

    public final PerfTParser withNamePrefix(String namePrefix) {
        this.namePrefix = namePrefix;
        return this;
    }

    public final PerfTParser withStartPositionPrefix(String startPositionPrefix) {
        this.startPositionPrefix = startPositionPrefix;
        return this;
    }

    public final PerfTParser withStartPositionCustomizer(UnaryOperator<String> startPositionCustomizer) {
        this.startPositionCustomizer = startPositionCustomizer;
        return this;
    }

    public final PerfTParser withResultPrefix(String resultPrefix) {
        this.resultPrefix = resultPrefix;
        return this;
    }

    public List<PerfTTestData> read(InputStream stream, Charset cs) throws IOException {
        ArrayList<PerfTTestData> tests = new ArrayList<PerfTTestData>();
        try (BufferedReader reader = new BufferedReader(new UnclosedReader(stream, cs));){
            PerfTTestData current = null;
            String name = null;
            String start = null;
            int lineNumber = 0;
            String line = reader.readLine();
            while (line != null) {
                ++lineNumber;
                if (line.startsWith(this.namePrefix)) {
                    name = line.substring(this.namePrefix.length()).trim();
                    current = null;
                } else if (line.startsWith(this.startPositionPrefix)) {
                    start = (String)this.startPositionCustomizer.apply(line.substring(this.startPositionPrefix.length()).trim());
                    current = null;
                } else if (line.startsWith(this.resultPrefix)) {
                    if (current == null) {
                        if (start == null) {
                            throw new IllegalArgumentException("Found " + this.resultPrefix + " before any start position");
                        }
                        current = new PerfTTestData(name, start);
                        name = null;
                        start = null;
                        tests.add(current);
                    }
                    this.addResultLine(current, lineNumber, line);
                }
                line = reader.readLine();
            }
        }
        return tests;
    }

    private void addResultLine(PerfTTestData current, int lineNumber, String line) throws IOException {
        String[] fields = line.substring(this.resultPrefix.length()).trim().split(" ");
        try {
            int depth = Integer.parseInt(fields[0]);
            if (depth != current.getSize() + 1) {
                throw new IllegalArgumentException("Seems depths are not sequential or don't start at 1");
            }
            long count = Long.parseLong(fields[1]);
            current.add(count);
        }
        catch (RuntimeException e) {
            throw new IOException("Problem while parsing line " + lineNumber, e);
        }
    }

    private static class UnclosedReader
    extends InputStreamReader {
        public UnclosedReader(InputStream in, Charset set) {
            super(in, set);
        }

        @Override
        public void close() throws IOException {
        }
    }
}

