/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.games.perft;

import com.fathzer.games.MoveGenerator;
import com.fathzer.games.perft.ForkJoinPerfT;
import com.fathzer.games.perft.MultiThreadedPerfT;
import com.fathzer.games.perft.PerfT;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;

public class PerfTBuilder<M> {
    private boolean playLeaves = true;
    private ExecutorService exec = null;
    private MoveGenerator.MoveConfidence moveType = MoveGenerator.MoveConfidence.PSEUDO_LEGAL;

    public void setPlayLeaves(boolean playLeaves) {
        this.playLeaves = playLeaves;
        if (!playLeaves) {
            this.moveType = MoveGenerator.MoveConfidence.LEGAL;
        }
    }

    public void setLegalMoves(boolean legal) {
        MoveGenerator.MoveConfidence moveConfidence = this.moveType = legal ? MoveGenerator.MoveConfidence.LEGAL : MoveGenerator.MoveConfidence.PSEUDO_LEGAL;
        if (!legal) {
            this.playLeaves = true;
        }
    }

    public void setExecutor(ExecutorService exec) {
        this.exec = exec;
    }

    public PerfT<M> build(MoveGenerator<M> generator, int depth) {
        if (this.exec == null) {
            return new PerfT<M>(generator, depth, this.playLeaves, this.moveType);
        }
        ExecutorService executorService = this.exec;
        if (executorService instanceof ForkJoinPool) {
            ForkJoinPool fjp = (ForkJoinPool)executorService;
            return new ForkJoinPerfT<M>(fjp, generator, depth, this.playLeaves, this.moveType);
        }
        return new MultiThreadedPerfT<M>(this.exec, generator, depth, this.playLeaves, this.moveType);
    }
}

