/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.games.perft;

import com.fathzer.games.MoveGenerator;
import com.fathzer.games.perft.Divide;
import com.fathzer.games.perft.PerfTResult;
import com.fathzer.games.util.UncheckedException;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;

public class PerfT<M> {
    final boolean playLeaves;
    final MoveGenerator.MoveConfidence moveType;
    final MoveGenerator<M> board;
    private final AtomicBoolean started = new AtomicBoolean();
    final int depth;
    final PerfTResult<M> result;

    PerfT(MoveGenerator<M> board, int depth, boolean playLeaves, MoveGenerator.MoveConfidence moveType) {
        if (depth <= 0) {
            throw new IllegalArgumentException("Search depth MUST be > 0");
        }
        if (board == null) {
            throw new IllegalArgumentException("Board cannot be null");
        }
        this.board = board;
        this.playLeaves = playLeaves;
        this.moveType = moveType;
        this.depth = depth;
        this.result = new PerfTResult();
    }

    public PerfTResult<M> get() {
        if (!this.started.compareAndSet(false, true)) {
            throw new IllegalStateException("This PerfT has already been started");
        }
        try {
            List<M> moves = this.getMoves(this.board);
            this.result.addMovesFound(moves.size());
            this.compute(moves);
            return this.result;
        }
        catch (UncheckedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UncheckedException(e);
        }
    }

    void compute(List<M> moves) {
        for (M move : moves) {
            Divide<M> divide = this.getRootPerfT(this.board, move, this.depth - 1);
            if (divide == null) continue;
            this.result.add(divide);
        }
    }

    List<M> getMoves(MoveGenerator<M> moveGenerator) {
        return MoveGenerator.MoveConfidence.LEGAL == this.moveType ? moveGenerator.getLegalMoves() : moveGenerator.getMoves();
    }

    Divide<M> getRootPerfT(MoveGenerator<M> moveGenerator, M move, int depth) {
        long leaves;
        if (depth == 0 && !this.playLeaves) {
            leaves = 1L;
        } else if (moveGenerator.makeMove(move, this.moveType)) {
            this.result.addMoveMade();
            leaves = new PerfTTask(moveGenerator, depth).call();
            moveGenerator.unmakeMove();
        } else {
            return null;
        }
        return new Divide<M>(move, leaves);
    }

    public boolean isInterrupted() {
        if (this.result.isInterrupted()) {
            return true;
        }
        if (Thread.interrupted()) {
            Thread.currentThread().interrupt();
            this.result.setInterrupted(true);
        }
        return this.result.isInterrupted();
    }

    public void interrupt() {
        this.result.setInterrupted(true);
    }

    class PerfTTask
    implements Callable<Long> {
        private final MoveGenerator<M> generator;
        private int depth;

        public PerfTTask(MoveGenerator<M> generator, int depth) {
            this.generator = generator;
            this.depth = depth;
        }

        @Override
        public Long call() {
            if (PerfT.this.isInterrupted()) {
                PerfT.this.result.setInterrupted(true);
                return 1L;
            }
            if (this.depth == 0) {
                return 1L;
            }
            List moves = PerfT.this.getMoves(this.generator);
            PerfT.this.result.addMovesFound(moves.size());
            if (this.depth == 1 && !PerfT.this.playLeaves) {
                return moves.size();
            }
            return this.process(moves);
        }

        protected Long process(List<M> moves) {
            long count = 0L;
            for (Object move : moves) {
                if (!this.generator.makeMove(move, PerfT.this.moveType)) continue;
                PerfT.this.result.addMoveMade();
                count += this.goDeeper().longValue();
                this.generator.unmakeMove();
            }
            return count;
        }

        protected Long goDeeper() {
            --this.depth;
            long nbLeaves = this.call();
            ++this.depth;
            return nbLeaves;
        }
    }
}

