/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.games.perft;

import com.fathzer.games.MoveGenerator;
import com.fathzer.games.perft.Divide;
import com.fathzer.games.perft.PerfT;
import com.fathzer.games.util.UncheckedException;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

class MultiThreadedPerfT<M>
extends PerfT<M> {
    final ExecutorService exec;

    MultiThreadedPerfT(ExecutorService exec, MoveGenerator<M> board, int depth, boolean playLeaves, MoveGenerator.MoveConfidence moveType) {
        super(board, depth, playLeaves, moveType);
        this.exec = exec;
    }

    @Override
    void compute(List<M> moves) {
        List<Future<Divide<M>>> results = moves.stream().map(m -> this.exec.submit(this.getDivideTask(this.board, m, this.depth))).toList();
        this.addDivides(results);
    }

    private Callable<Divide<M>> getDivideTask(MoveGenerator<M> board, M move, int depth) {
        return () -> this.getRootPerfT((MoveGenerator)board.fork(), move, depth - 1);
    }

    void addDivides(List<Future<Divide<M>>> results) {
        try {
            for (Future<Divide<M>> f : results) {
                Divide<M> divide = f.get();
                if (divide == null) continue;
                this.result.add(divide);
            }
        }
        catch (InterruptedException e) {
            this.result.setInterrupted(true);
            this.interrupt();
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            throw new UncheckedException(e.getCause());
        }
    }
}

