/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.games.perft;

import com.fathzer.games.MoveGenerator;
import com.fathzer.games.perft.FromPositionMoveGeneratorBuilder;
import com.fathzer.games.perft.PerfT;
import com.fathzer.games.perft.PerfTBuilder;
import com.fathzer.games.perft.PerfTTestData;
import java.io.Serializable;
import java.util.Collection;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;

public class MoveGeneratorChecker {
    private final Collection<PerfTTestData> tests;
    private Consumer<PerfTCountError> countErrorManager = e -> {
        throw new PerfTCountException((PerfTCountError)e);
    };
    private Consumer<RuntimeException> errorManager = e -> {
        throw e;
    };
    private AtomicReference<PerfT<?>> current;
    private volatile boolean cancelled;
    private AtomicBoolean running = new AtomicBoolean();

    public MoveGeneratorChecker(Collection<PerfTTestData> tests) {
        this.tests = tests;
    }

    public void setCountErrorManager(Consumer<PerfTCountError> countErrorManager) {
        this.countErrorManager = countErrorManager;
    }

    public void setErrorManager(Consumer<RuntimeException> errorManager) {
        this.errorManager = errorManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <M, B extends MoveGenerator<M>> long run(FromPositionMoveGeneratorBuilder<M, B> engine, int depth, boolean legalMoves, boolean playLeaves, int parallelism) {
        if (parallelism <= 0) {
            throw new IllegalArgumentException("Parallelism must be > 0");
        }
        if (!this.running.compareAndSet(false, true)) {
            throw new IllegalStateException("A test is already running");
        }
        this.cancelled = false;
        long count = 0L;
        ForkJoinPool threads = new ForkJoinPool(parallelism);
        try {
            PerfTBuilder perfT = new PerfTBuilder();
            perfT.setExecutor(threads);
            perfT.setPlayLeaves(playLeaves);
            perfT.setLegalMoves(legalMoves);
            for (PerfTTestData test : this.tests) {
                if (test.getSize() < depth) continue;
                try {
                    B generator = engine.fromPosition(test.getStartPosition());
                    MoveGeneratorChecker moveGeneratorChecker = this;
                    synchronized (moveGeneratorChecker) {
                        if (this.cancelled) {
                            break;
                        }
                        this.current.set(perfT.build(generator, depth));
                    }
                    count += this.doTest(test, depth);
                }
                catch (Exception e) {
                    this.errorManager.accept(new RuntimeException("Exception for " + test.getStartPosition(), e));
                    this.interrupt();
                }
            }
        }
        finally {
            threads.shutdown();
            this.running.set(false);
        }
        return count;
    }

    private <M> long doTest(PerfTTestData test, int depth) {
        long expected;
        long count = this.current.get().get().getNbLeaves();
        if (count != (expected = test.getExpectedLeaveCount(depth)) && !this.cancelled) {
            this.countErrorManager.accept(new PerfTCountError(test.getStartPosition(), expected, count));
        }
        return count;
    }

    public synchronized void interrupt() {
        this.cancelled = true;
        if (this.current != null) {
            this.current.get().interrupt();
        }
    }

    public record PerfTCountError(String startPosition, long expectedCount, long actualCount) implements Serializable
    {
        private static final long serialVersionUID = 1L;
    }

    public static class PerfTCountException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        private final PerfTCountError countError;

        private PerfTCountException(PerfTCountError countError) {
            super("Error for " + countError.startPosition() + " expected " + countError.expectedCount() + " got " + countError.actualCount());
            this.countError = countError;
        }

        public PerfTCountError getCountError() {
            return this.countError;
        }
    }
}

