/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.games.perft;

import com.fathzer.games.MoveGenerator;
import com.fathzer.games.perft.Divide;
import com.fathzer.games.perft.MultiThreadedPerfT;
import com.fathzer.games.perft.PerfTResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.RecursiveTask;

class ForkJoinPerfT<M>
extends MultiThreadedPerfT<M> {
    ForkJoinPerfT(ForkJoinPool exec, MoveGenerator<M> board, int depth, boolean playLeaves, MoveGenerator.MoveConfidence moveType) {
        super(exec, board, depth, playLeaves, moveType);
    }

    @Override
    void compute(List<M> moves) {
        List<DivideJob> jobs = moves.stream().map(move -> this.getDivideJob(move, this.result)).filter(Objects::nonNull).toList();
        jobs.stream().forEach(((ForkJoinPool)this.exec)::submit);
        this.addDivides(jobs.stream().map(job -> job).toList());
    }

    private DivideJob getDivideJob(M move, PerfTResult<M> result) {
        if (!this.board.makeMove(move, this.moveType)) {
            return null;
        }
        result.addMoveMade();
        DivideJob job = new DivideJob(move, new CountTask((MoveGenerator)this.board.fork(), this.depth - 1, result));
        this.board.unmakeMove();
        return job;
    }

    private class DivideJob
    extends RecursiveTask<Divide<M>> {
        M move;
        CountTask task;

        DivideJob(M move, CountTask task) {
            this.move = move;
            this.task = task;
        }

        @Override
        public Divide<M> compute() {
            return new Divide(this.move, this.task.compute());
        }
    }

    private class CountTask
    extends RecursiveTask<Long> {
        private final MoveGenerator<M> board;
        private final int depth;
        private final PerfTResult<M> perftResult;

        CountTask(MoveGenerator<M> board, int depth, PerfTResult<M> result) {
            this.board = board;
            this.depth = depth;
            this.perftResult = result;
        }

        @Override
        protected Long compute() {
            if (ForkJoinPerfT.this.isInterrupted() || this.depth == 0) {
                return 1L;
            }
            List moves = ForkJoinPerfT.this.getMoves(this.board);
            this.perftResult.addMovesFound(moves.size());
            if (this.depth == 1 && !ForkJoinPerfT.this.playLeaves) {
                return moves.size();
            }
            return this.depth >= 4 ? this.forkedCount(moves) : this.count(moves);
        }

        protected long forkedCount(List<M> moves) {
            ArrayList<CountTask> tasks = new ArrayList<CountTask>(moves.size());
            for (Object move : moves) {
                if (!this.board.makeMove(move, ForkJoinPerfT.this.moveType)) continue;
                this.perftResult.addMoveMade();
                tasks.add(new CountTask((MoveGenerator)this.board.fork(), this.depth - 1, this.perftResult));
                this.board.unmakeMove();
            }
            tasks.forEach(ForkJoinTask::fork);
            return tasks.stream().mapToLong(ForkJoinTask::join).sum();
        }

        protected long count(List<M> moves) {
            long count = 0L;
            for (Object move : moves) {
                if (!this.board.makeMove(move, ForkJoinPerfT.this.moveType)) continue;
                this.perftResult.addMoveMade();
                count += new CountTask(this.board, this.depth - 1, this.perftResult).compute().longValue();
                this.board.unmakeMove();
            }
            return count;
        }
    }
}

