/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.games.movelibrary;

import com.fathzer.games.ai.evaluation.EvaluatedMove;
import com.fathzer.games.movelibrary.MoveLibrary;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;

public abstract class AbstractMoveLibrary<R, M, B>
implements MoveLibrary<M, B> {
    private static Random rnd = new Random();
    private Function<List<R>, R> moveSelector = AbstractMoveLibrary.randomMoveSelector();
    private MoveLibrary<M, B> other;

    public static <T> Function<List<T>, T> firstMoveSelector() {
        return l -> l.get(0);
    }

    public static <T> Function<List<T>, T> randomMoveSelector() {
        return l -> l.get(rnd.nextInt(l.size()));
    }

    public Function<List<R>, R> weightedMoveSelector() {
        return values -> {
            long count = values.stream().mapToLong(this::getWeight).sum();
            long value = rnd.nextLong(count);
            count = 0L;
            int index = values.size() - 1;
            for (int i = 0; i < values.size(); ++i) {
                if (value >= (count += this.getWeight(values.get(i)))) continue;
                index = i;
                break;
            }
            return values.get(index);
        };
    }

    protected abstract List<R> getRecords(B var1);

    protected abstract EvaluatedMove<M> toEvaluatedMove(B var1, R var2);

    public void setMoveSelector(Function<List<R>, R> moveSelector) {
        this.moveSelector = moveSelector;
    }

    public void setNext(MoveLibrary<M, B> next) {
        this.other = next;
    }

    @Override
    public List<EvaluatedMove<M>> getMoves(B board) {
        List<R> moves = this.getRecords(board);
        if (moves.isEmpty()) {
            return this.other == null ? Collections.emptyList() : this.other.getMoves(board);
        }
        return moves.stream().map(r -> this.toEvaluatedMove(board, r)).toList();
    }

    @Override
    public Optional<EvaluatedMove<M>> apply(B board) {
        List<R> moves = this.getRecords(board);
        if (moves.isEmpty()) {
            return this.other == null ? Optional.empty() : this.other.apply((Object)board);
        }
        R selectedRecord = this.moveSelector.apply(moves);
        return Optional.of(this.toEvaluatedMove(board, selectedRecord));
    }

    protected long getWeight(R move) {
        return 1L;
    }

    @Override
    public void newGame() {
        if (this.other != null) {
            this.other.newGame();
        }
    }
}

