/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.games.ai.transposition;

import com.fathzer.games.HashProvider;
import com.fathzer.games.MoveGenerator;
import com.fathzer.games.ai.transposition.EntryType;
import com.fathzer.games.ai.transposition.TranspositionTableEntry;
import com.fathzer.games.ai.transposition.TranspositionTablePolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;

public interface TranspositionTable<M, B extends MoveGenerator<M>> {
    public TranspositionTableEntry<M> get(long var1);

    public boolean store(long var1, EntryType var3, int var4, int var5, M var6, Predicate<TranspositionTableEntry<M>> var7);

    public void newPosition(B var1);

    public void newGame();

    public TranspositionTablePolicy<M, B> getPolicy();

    public void setPolicy(TranspositionTablePolicy<M, B> var1);

    default public <T extends MoveGenerator<M> & HashProvider> List<M> collectPV(T board, int maxDepth) {
        int i;
        ArrayList arrayPV = new ArrayList(maxDepth);
        TranspositionTableEntry<M> entry = this.get(((HashProvider)board).getHashKey());
        for (i = 0; i < maxDepth; ++i) {
            Object move;
            Object e = move = entry != null && entry.isValid() ? (Object)entry.getMove() : null;
            if (move == null || !board.makeMove(move, MoveGenerator.MoveConfidence.UNSAFE)) break;
            arrayPV.add(move);
            entry = this.get(((HashProvider)board).getHashKey());
        }
        for (i = 0; i < arrayPV.size(); ++i) {
            board.unmakeMove();
        }
        return arrayPV;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public <T extends MoveGenerator<M> & HashProvider> List<M> collectPV(T board, M move, int maxDepth) {
        if (maxDepth == 0) {
            return Collections.singletonList(move);
        }
        if (board.makeMove(move, MoveGenerator.MoveConfidence.UNSAFE)) {
            try {
                List<M> result = this.collectPV(board, maxDepth - 1);
                result.add(0, move);
                List<M> list = result;
                return list;
            }
            finally {
                board.unmakeMove();
            }
        }
        throw new IllegalArgumentException("Move is not legal");
    }

    public int getSize();

    public int getMemorySizeMB();

    default public Iterator<TranspositionTableEntry<M>> getEntries() {
        throw new UnsupportedOperationException();
    }

    default public int getEntryCount() {
        return -1;
    }
}

