/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.games.ai.transposition;

import com.fathzer.games.MoveGenerator;
import com.fathzer.games.ai.DepthFirstAI;
import com.fathzer.games.ai.DepthFirstSearchParameters;
import com.fathzer.games.ai.evaluation.Evaluator;
import com.fathzer.games.ai.transposition.TranspositionTable;

public interface TTAi<M, B extends MoveGenerator<M>>
extends DepthFirstAI<M, DepthFirstSearchParameters> {
    public void setTranspositonTable(TranspositionTable<M, B> var1);

    public TranspositionTable<M, B> getTranspositionTable();

    default public int scoreToTT(int score, int depth, int maxDepth, Evaluator<?, ?> evaluator) {
        if (evaluator.isWinLooseScore(score)) {
            int nbHalfMoves = maxDepth - depth;
            return score > 0 ? score + nbHalfMoves : score - nbHalfMoves;
        }
        return score;
    }

    default public int ttToScore(int encodedValue, int depth, int maxDepth, Evaluator<?, ?> evaluator) {
        if (evaluator.isWinLooseScore(encodedValue)) {
            int nbHalfMoves = maxDepth - depth;
            return encodedValue > 0 ? encodedValue - nbHalfMoves : encodedValue + nbHalfMoves;
        }
        return encodedValue;
    }
}

