/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.games.ai.transposition;

import com.fathzer.games.MoveGenerator;
import com.fathzer.games.ai.transposition.BasicPolicy;
import com.fathzer.games.ai.transposition.EntryType;
import com.fathzer.games.ai.transposition.OneLongEntry;
import com.fathzer.games.ai.transposition.SizeUnit;
import com.fathzer.games.ai.transposition.TranspositionTable;
import com.fathzer.games.ai.transposition.TranspositionTableEntry;
import com.fathzer.games.ai.transposition.TranspositionTablePolicy;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Predicate;

public abstract class OneLongEntryTranspositionTable<M, B extends MoveGenerator<M>>
implements TranspositionTable<M, B> {
    private static final int SLOTS = 2;
    private final AtomicLongArray table;
    private final ReadWriteLock lock;
    private final int size;
    private int entryCount;
    private TranspositionTablePolicy<M, B> policy;

    protected OneLongEntryTranspositionTable(int size, SizeUnit unit) {
        this.size = (int)((long)size * (long)unit.getSize()) / 8 / 2;
        this.table = new AtomicLongArray(this.size * 2);
        this.lock = new ReentrantReadWriteLock();
        this.policy = new BasicPolicy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TranspositionTableEntry<M> get(long key) {
        int index = this.getKeyIndex(key);
        OneLongEntry<Object> entry = new OneLongEntry<Object>(this::toMove);
        this.lock.readLock().lock();
        try {
            OneLongEntry<Object> oneLongEntry = entry.set(key, this.table.get(index) == key ? this.table.get(index + 1) : 0L);
            return oneLongEntry;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private int getKeyIndex(long key) {
        return Math.abs((int)(key % (long)this.size) * 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean store(long key, EntryType type, int depth, int value, M move, Predicate<TranspositionTableEntry<M>> validator) {
        int index = this.getKeyIndex(key);
        OneLongEntry<Object> entry = new OneLongEntry<Object>(this::toMove);
        this.lock.writeLock().lock();
        try {
            entry.set(this.table.get(index), this.table.get(index + 1));
            boolean written = validator.test(entry);
            if (written) {
                if (!entry.isValid()) {
                    ++this.entryCount;
                }
                this.table.set(index, key);
                this.table.set(index + 1, OneLongEntry.toLong(type, (byte)depth, (short)value, this.toInt(move)));
            }
            boolean bl = written;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public TranspositionTablePolicy<M, B> getPolicy() {
        return this.policy;
    }

    @Override
    public void setPolicy(TranspositionTablePolicy<M, B> policy) {
        this.policy = policy;
    }

    protected abstract int toInt(M var1);

    protected abstract M toMove(int var1);

    @Override
    public void newGame() {
        for (int i = 0; i < this.table.length(); ++i) {
            this.table.set(i, 0L);
        }
        this.entryCount = 0;
    }

    @Override
    public void newPosition(B board) {
        this.newGame();
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public int getEntryCount() {
        return this.entryCount;
    }

    @Override
    public final int getMemorySizeMB() {
        return (int)((long)this.size * 8L * 2L / (long)SizeUnit.MB.getSize());
    }

    @Override
    public Iterator<TranspositionTableEntry<M>> getEntries() {
        return new TTIterator();
    }

    private class TTIterator
    implements Iterator<TranspositionTableEntry<M>> {
        private final int max;
        private int index = 0;
        private OneLongEntry<M> entry = new OneLongEntry<Object>(OneLongEntryTranspositionTable.this::toMove);

        private TTIterator() {
            this.max = OneLongEntryTranspositionTable.this.size * 2;
            this.entry = new OneLongEntry<Object>(OneLongEntryTranspositionTable.this::toMove);
            this.prepareNext();
        }

        private void prepareNext() {
            while (this.index < this.max) {
                long value = OneLongEntryTranspositionTable.this.table.get(this.index + 1);
                if (value != 0L) {
                    this.entry.set(OneLongEntryTranspositionTable.this.table.get(this.index), value);
                    break;
                }
                this.index += 2;
            }
            if (this.index >= this.max) {
                this.entry = null;
            }
        }

        @Override
        public boolean hasNext() {
            return this.entry != null;
        }

        @Override
        public TranspositionTableEntry<M> next() {
            if (this.entry == null) {
                throw new NoSuchElementException();
            }
            OneLongEntry result = this.entry;
            this.index += 2;
            this.prepareNext();
            return result;
        }
    }
}

