/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.games.ai.transposition;

import com.fathzer.games.ai.transposition.EntryType;
import com.fathzer.games.ai.transposition.TranspositionTableEntry;
import java.util.function.IntFunction;

class OneLongEntry<M>
implements TranspositionTableEntry<M> {
    private static final long MOVE_MASK = 0xFFFFFFFFL;
    private static final int SCORE_SHIFT = 32;
    private static final long SCORE_MASK = 0xFFFF00000000L;
    private static final int DEPTH_SHIFT = 48;
    private static final long DEPTH_MASK = 0xFF000000000000L;
    private static final int TYPE_SHIFT = 56;
    private static final long TYPE_MASK = 0x300000000000000L;
    private final IntFunction<M> toMove;
    private long key;
    private long value;

    OneLongEntry(IntFunction<M> toMove) {
        this.toMove = toMove;
    }

    OneLongEntry<M> set(long key, long value) {
        this.key = key;
        this.value = value;
        return this;
    }

    @Override
    public long getKey() {
        return this.key;
    }

    @Override
    public boolean isValid() {
        return this.value != 0L;
    }

    @Override
    public EntryType getEntryType() {
        return EntryType.ALL.get((int)((this.value & 0x300000000000000L) >> 56));
    }

    static long toLong(EntryType type, byte depth, short value, int move) {
        return type == EntryType.INVALID ? 0L : (long)type.ordinal() << 56 & 0x300000000000000L | (long)depth << 48 & 0xFF000000000000L | (long)value << 32 & 0xFFFF00000000L | (long)move & 0xFFFFFFFFL;
    }

    @Override
    public int getDepth() {
        return (byte)((this.value & 0xFF000000000000L) >> 48);
    }

    @Override
    public int getValue() {
        return (short)((this.value & 0xFFFF00000000L) >> 32);
    }

    @Override
    public M getMove() {
        return this.toMove.apply((int)(this.value & 0xFFFFFFFFL));
    }

    public String toString() {
        return this.key + ":" + this.getEntryType() + " " + this.getValue() + " at " + this.getDepth() + " -> " + this.getMove();
    }
}

