/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.games.ai.transposition;

import com.fathzer.games.MoveGenerator;
import com.fathzer.games.ai.transposition.AlphaBetaState;
import com.fathzer.games.ai.transposition.EntryType;
import com.fathzer.games.ai.transposition.TranspositionTable;
import com.fathzer.games.ai.transposition.TranspositionTableEntry;
import com.fathzer.games.ai.transposition.TranspositionTablePolicy;
import java.util.function.IntUnaryOperator;

public class BasicPolicy<M, B extends MoveGenerator<M>>
implements TranspositionTablePolicy<M, B> {
    @Override
    public AlphaBetaState<M> accept(TranspositionTableEntry<M> entry, int depth, int alpha, int beta, IntUnaryOperator fromTTScoreConverter) {
        AlphaBetaState<M> state = new AlphaBetaState<M>(depth, alpha, beta);
        if (entry != null && entry.isValid()) {
            if (entry.getDepth() >= depth) {
                int value = fromTTScoreConverter.applyAsInt(entry.getValue());
                if (EntryType.EXACT == entry.getEntryType()) {
                    state.setValue(value);
                } else {
                    this.acceptNonExactRecord(entry, alpha, beta, value, state);
                }
            }
            state.setBestMove(entry.getMove());
        }
        return state;
    }

    protected void acceptNonExactRecord(TranspositionTableEntry<M> entry, int alpha, int beta, int value, AlphaBetaState<M> state) {
        boolean updated = false;
        if (EntryType.LOWER_BOUND == entry.getEntryType()) {
            boolean bl = updated = value > alpha;
            if (updated) {
                alpha = value;
            }
        } else if (EntryType.UPPER_BOUND == entry.getEntryType()) {
            boolean bl = updated = value < beta;
            if (updated) {
                beta = value;
            }
        }
        if (updated) {
            if (alpha >= beta) {
                state.setValue(value);
            } else {
                state.updateAlphaBeta(alpha, beta);
            }
        }
    }

    @Override
    public boolean store(TranspositionTable<M, B> table, long key, AlphaBetaState<M> state, IntUnaryOperator toTTScoreConverter) {
        EntryType type = state.getValue() <= state.getAlpha() ? EntryType.UPPER_BOUND : (state.getValue() >= state.getBetaUpdated() ? EntryType.LOWER_BOUND : EntryType.EXACT);
        return table.store(key, type, state.getDepth(), toTTScoreConverter.applyAsInt(state.getValue()), state.getBestMove(), p -> this.shouldReplace((TranspositionTableEntry<M>)p, key, state.getDepth(), type));
    }

    protected boolean shouldReplace(TranspositionTableEntry<M> entry, long newKey, int newDepth, EntryType newType) {
        if (!entry.isValid()) {
            return true;
        }
        if (entry.getEntryType() == EntryType.EXACT && newType != EntryType.EXACT) {
            return false;
        }
        if (newType == EntryType.EXACT && entry.getEntryType() != EntryType.EXACT) {
            return true;
        }
        return newDepth > entry.getDepth();
    }
}

