/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.games.ai.time;

import com.fathzer.games.ai.time.RemainingMoveCountPredictor;
import com.fathzer.games.ai.time.TimeManager;
import com.fathzer.games.clock.CountDownState;

public class BasicTimeManager<B>
implements TimeManager<B> {
    private final RemainingMoveCountPredictor<B> oracle;

    public BasicTimeManager(RemainingMoveCountPredictor<B> oracle) {
        this.oracle = oracle;
    }

    @Override
    public long getMaxTime(B data, CountDownState countDown) {
        int movesToGo = countDown.getMovesToGo();
        if (movesToGo == 0) {
            movesToGo = this.oracle.getRemainingHalfMoves(data);
            movesToGo = (movesToGo + 1) / 2;
        }
        long remainingMs = countDown.getRemainingMs() + countDown.getIncrementMs() * (long)(movesToGo - 1);
        return remainingMs / (long)movesToGo;
    }
}

