/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.games.ai.moveselector;

import com.fathzer.games.ai.evaluation.EvaluatedMove;
import com.fathzer.games.ai.moveselector.MoveSelector;
import java.util.List;
import java.util.OptionalInt;
import java.util.function.ToIntFunction;

public class StaticMoveSelector<M, D>
extends MoveSelector<M, D> {
    private final ToIntFunction<M> evaluator;

    public StaticMoveSelector(ToIntFunction<M> evaluator) {
        this.evaluator = evaluator;
    }

    @Override
    public List<EvaluatedMove<M>> select(D data, List<EvaluatedMove<M>> result) {
        OptionalInt maxImmediateValue = result.stream().mapToInt(em -> this.evaluator.applyAsInt(em.getMove())).max();
        result = result.stream().filter(em -> this.evaluator.applyAsInt(em.getMove()) == maxImmediateValue.getAsInt()).toList();
        return super.select(data, result);
    }
}

