/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.games.ai.moveselector;

import com.fathzer.games.ai.evaluation.EvaluatedMove;
import java.util.List;
import java.util.Optional;

public abstract class MoveSelector<M, D> {
    private MoveSelector<M, D> next;

    protected MoveSelector() {
    }

    public MoveSelector<M, D> setNext(MoveSelector<M, D> next) {
        this.next = next;
        return this;
    }

    public List<EvaluatedMove<M>> select(D data, List<EvaluatedMove<M>> moveLIst) {
        if (moveLIst.size() > 1 && this.next != null) {
            return this.next.select(data, moveLIst);
        }
        return moveLIst;
    }

    public Optional<EvaluatedMove<M>> get(D data, List<EvaluatedMove<M>> moveList) {
        List<EvaluatedMove<M>> selected = this.select(data, moveList);
        return selected == null || selected.isEmpty() ? Optional.empty() : Optional.of(selected.get(0));
    }
}

