/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.games.ai.iterativedeepening;

import com.fathzer.games.ai.SearchParameters;
import com.fathzer.games.ai.evaluation.EvaluatedMove;
import com.fathzer.games.ai.moveselector.MoveSelector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SearchHistory<M> {
    private final SearchParameters params;
    private final List<List<EvaluatedMove<M>>> results;
    private final List<Integer> depths;

    public SearchHistory(SearchParameters params) {
        if (params == null) {
            throw new IllegalArgumentException();
        }
        this.params = params;
        this.results = new ArrayList<List<EvaluatedMove<M>>>();
        this.depths = new ArrayList<Integer>();
    }

    public void add(List<EvaluatedMove<M>> result, int depth) {
        if (depth < 0 || !this.isEmpty() && depth <= this.depths.get(this.depths.size() - 1)) {
            throw new IllegalArgumentException();
        }
        this.results.add(result);
        this.depths.add(depth);
    }

    public SearchParameters getSearchParameters() {
        return this.params;
    }

    public int length() {
        return this.results.size();
    }

    public boolean isEmpty() {
        return this.getLastList().isEmpty();
    }

    public int getDepth(int index) {
        return this.depths.get(index);
    }

    public List<EvaluatedMove<M>> getList(int index) {
        return this.results.get(index);
    }

    public List<EvaluatedMove<M>> getAccurateMoves(int index) {
        return this.results.get(index).subList(0, this.params.getAccurateMovesCount(this.results.get(index)));
    }

    public int getLastDepth() {
        return this.results.isEmpty() ? 0 : this.depths.get(this.results.size() - 1);
    }

    public List<EvaluatedMove<M>> getLastList() {
        return this.results.isEmpty() ? Collections.emptyList() : this.results.get(this.results.size() - 1);
    }

    public List<EvaluatedMove<M>> getAccurateMoves() {
        return this.results.isEmpty() ? Collections.emptyList() : this.getAccurateMoves(this.length() - 1);
    }

    public EvaluatedMove<M> getBestMove(MoveSelector<M, SearchHistory<M>> selector) {
        List<EvaluatedMove<M>> list = this.getLastList();
        if (list.isEmpty()) {
            return null;
        }
        List<EvaluatedMove<M>> bestMoves = list.subList(0, this.params.getBestMovesCount(list));
        return selector.get(this, bestMoves).orElse(null);
    }
}

